/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.client.ClientCapabilities;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.informationschema.InformationSchemaColumnHandle;
import io.prestosql.connector.informationschema.InformationSchemaMetadata;
import io.prestosql.connector.informationschema.InformationSchemaTableHandle;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.metadata.ViewDefinition;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.testing.TestingConnectorContext;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInformationSchemaMetadata {
    private static final JsonCodec<ViewDefinition> VIEW_DEFINITION_JSON_CODEC = JsonCodec.jsonCodec(ViewDefinition.class);
    private final TransactionManager transactionManager;
    private final Metadata metadata;

    public TestInformationSchemaMetadata() {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder();
        MockConnectorFactory mockConnectorFactory = builder.withListSchemaNames(connectorSession -> ImmutableList.of((Object)"test_schema")).withListTables((connectorSession, schemaNameOrNull) -> ImmutableList.of((Object)new SchemaTableName("test_schema", "test_view"), (Object)new SchemaTableName("test_schema", "another_table"))).withGetViews((connectorSession, prefix) -> {
            String viewJson = VIEW_DEFINITION_JSON_CODEC.toJson((Object)new ViewDefinition("select 1", Optional.of("test_catalog"), Optional.of("test_schema"), (List)ImmutableList.of(), Optional.empty(), false));
            SchemaTableName viewName = new SchemaTableName("test_schema", "test_view");
            return ImmutableMap.of((Object)viewName, (Object)new ConnectorViewDefinition(viewName, Optional.empty(), viewJson));
        }).build();
        Connector testConnector = mockConnectorFactory.create("test", (Map<String, String>)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        CatalogManager catalogManager = new CatalogManager();
        String catalogName = "test_catalog";
        CatalogName catalog = new CatalogName("test_catalog");
        catalogManager.registerCatalog(new Catalog(catalogName, catalog, testConnector, CatalogName.createInformationSchemaCatalogName((CatalogName)catalog), testConnector, CatalogName.createSystemTablesCatalogName((CatalogName)catalog), testConnector));
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
    }

    @Test
    public void testInformationSchemaPredicatePushdown() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = new ImmutableMap.Builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_schema"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_schema")));
        domains.put((Object)new InformationSchemaColumnHandle("table_name"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_view")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.build()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithConstraintPredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all(), bindings -> {
            NullableValue catalog = (NullableValue)bindings.get(new InformationSchemaColumnHandle("table_catalog"));
            NullableValue schema = (NullableValue)bindings.get(new InformationSchemaColumnHandle("table_schema"));
            NullableValue table = (NullableValue)bindings.get(new InformationSchemaColumnHandle("table_name"));
            boolean isValid = true;
            if (catalog != null) {
                isValid = ((Slice)catalog.getValue()).toStringUtf8().equals("test_catalog");
            }
            if (schema != null) {
                isValid &= ((Slice)schema.getValue()).toStringUtf8().equals("test_schema");
            }
            if (table != null) {
                isValid &= ((Slice)table.getValue()).toStringUtf8().equals("test_view");
            }
            return isValid;
        });
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assert.assertEquals((Set)tableHandle.getPrefixes(), (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    private static ConnectorSession createNewSession(TransactionId transactionId) {
        return TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("information_schema").setClientCapabilities((Set)Arrays.stream(ClientCapabilities.values()).map(Enum::toString).collect(ImmutableSet.toImmutableSet())).setTransactionId(transactionId).build().toConnectorSession();
    }
}

