/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.json.JsonModule;
import io.airlift.testing.Assertions;
import io.prestosql.connector.system.SystemTableHandle;
import io.prestosql.metadata.HandleJsonModule;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSystemTableHandle {
    private static final Map<String, Object> SCHEMA_AS_MAP = ImmutableMap.of((Object)"@type", (Object)"$system", (Object)"schemaName", (Object)"system_schema", (Object)"tableName", (Object)"system_table", (Object)"constraint", (Object)ImmutableMap.of((Object)"columnDomains", (Object)ImmutableList.of()));
    private ObjectMapper objectMapper;

    @BeforeMethod
    public void startUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), new HandleJsonModule()});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testSystemSerialize() throws Exception {
        SystemTableHandle internalHandle = new SystemTableHandle("system_schema", "system_table", TupleDomain.all());
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(SystemTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)internalHandle);
        this.testJsonEquals(json, SCHEMA_AS_MAP);
    }

    @Test
    public void testSystemDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(SCHEMA_AS_MAP);
        ConnectorTableHandle tableHandle = (ConnectorTableHandle)this.objectMapper.readValue(json, ConnectorTableHandle.class);
        Assert.assertEquals(tableHandle.getClass(), SystemTableHandle.class);
        SystemTableHandle systemHandle = (SystemTableHandle)tableHandle;
        Assert.assertEquals((Object)systemHandle.getSchemaTableName(), (Object)new SchemaTableName("system_schema", "system_table"));
    }

    private void testJsonEquals(String json, Map<String, Object> expectedMap) throws Exception {
        Map jsonMap = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assertions.assertEqualsIgnoreOrder(jsonMap.entrySet(), expectedMap.entrySet());
    }
}

