/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ViewDefinition;
import io.prestosql.spi.type.IntegerType;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestViewDefinition {
    private static final JsonCodec<ViewDefinition> CODEC = MetadataManager.createTestingViewCodec();
    private static final String BASE_JSON = "\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"integer\"}]";

    @Test
    public void testLegacyViewWithoutOwner() {
        ViewDefinition view = (ViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"integer\"}]}");
        TestViewDefinition.assertBaseView(view);
        Assert.assertFalse((boolean)view.getOwner().isPresent());
    }

    @Test
    public void testViewWithOwner() {
        ViewDefinition view = (ViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"integer\"}], \"owner\": \"abc\"}");
        TestViewDefinition.assertBaseView(view);
        Assert.assertEquals((Object)view.getOwner(), Optional.of("abc"));
        Assert.assertFalse((boolean)view.isRunAsInvoker());
    }

    @Test
    public void testViewSecurityDefiner() {
        ViewDefinition view = (ViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"integer\"}], \"owner\": \"abc\", \"runAsInvoker\": false}");
        TestViewDefinition.assertBaseView(view);
        Assert.assertEquals((Object)view.getOwner(), Optional.of("abc"));
        Assert.assertFalse((boolean)view.isRunAsInvoker());
    }

    @Test
    public void testViewSecurityInvoker() {
        ViewDefinition view = (ViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"integer\"}], \"runAsInvoker\": true}");
        TestViewDefinition.assertBaseView(view);
        Assert.assertFalse((boolean)view.getOwner().isPresent());
        Assert.assertTrue((boolean)view.isRunAsInvoker());
    }

    private static void assertBaseView(ViewDefinition view) {
        Assert.assertEquals((String)view.getOriginalSql(), (String)"SELECT 42 x");
        Assert.assertEquals((int)view.getColumns().size(), (int)1);
        ViewDefinition.ViewColumn column = (ViewDefinition.ViewColumn)Iterables.getOnlyElement((Iterable)view.getColumns());
        Assert.assertEquals((String)column.getName(), (String)"x");
        Assert.assertEquals((Object)column.getType(), (Object)IntegerType.INTEGER);
    }
}

