/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.HashAggregationOperator;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.StreamingAggregationOperator;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingTaskContext;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=5)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkHashAndStreamingAggregationOperators {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction LONG_SUM = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("sum", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}));
    private static final InternalAggregationFunction COUNT = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[0]));

    @Benchmark
    public List<Page> benchmark(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void verifyStreaming() {
        this.verify(1, "streaming");
        this.verify(10, "streaming");
        this.verify(1000, "streaming");
    }

    @Test
    public void verifyHash() {
        this.verify(1, "hash");
        this.verify(10, "hash");
        this.verify(1000, "hash");
    }

    private void verify(int rowsPerGroup, String operatorType) {
        Context context = new Context();
        context.operatorType = operatorType;
        context.rowsPerGroup = rowsPerGroup;
        context.setup();
        Assert.assertEquals((int)140, (int)context.getPages().size());
        for (int i = 0; i < 140; ++i) {
            Assert.assertEquals((int)10000, (int)context.getPages().get(i).getPositionCount());
        }
        List<Page> outputPages = this.benchmark(context);
        Assert.assertEquals((int)(1400000 / rowsPerGroup), (int)outputPages.stream().mapToInt(Page::getPositionCount).sum());
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkHashAndStreamingAggregationOperators.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        public static final int TOTAL_PAGES = 140;
        public static final int ROWS_PER_PAGE = 10000;
        @Param(value={"1", "10", "1000"})
        public int rowsPerGroup;
        @Param(value={"streaming", "hash"})
        public String operatorType;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            int groupsPerPage = 10000 / this.rowsPerGroup;
            boolean hashAggregation = this.operatorType.equalsIgnoreCase("hash");
            RowPagesBuilder pagesBuilder = RowPagesBuilder.rowPagesBuilder(hashAggregation, (List<Integer>)ImmutableList.of((Object)0), new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
            for (int i = 0; i < 140; ++i) {
                BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 10000);
                for (int j = 0; j < groupsPerPage; ++j) {
                    String groupKey = String.format("%s", i * groupsPerPage + j);
                    Context.repeatToStringBlock(groupKey, this.rowsPerGroup, blockBuilder);
                }
                pagesBuilder.addBlocksPage(blockBuilder.build(), BlockAssertions.createLongSequenceBlock(0, 10000));
            }
            this.pages = pagesBuilder.build();
            this.operatorFactory = hashAggregation ? this.createHashAggregationOperatorFactory(pagesBuilder.getHashChannel()) : this.createStreamingAggregationOperatorFactory();
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        private OperatorFactory createStreamingAggregationOperatorFactory() {
            return new StreamingAggregationOperator.StreamingAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)0), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)1), Optional.empty())), new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()));
        }

        private OperatorFactory createHashAggregationOperatorFactory(Optional<Integer> hashChannel) {
            JoinCompiler joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
            SpillerFactory spillerFactory = (types, localSpillContext, aggregatedMemoryContext) -> null;
            return new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)0), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)1), Optional.empty())), hashChannel, Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), false, DataSize.succinctBytes((long)8L), DataSize.succinctBytes((long)Integer.MAX_VALUE), spillerFactory, joinCompiler, false);
        }

        private static void repeatToStringBlock(String value, int count, BlockBuilder blockBuilder) {
            for (int i = 0; i < count; ++i) {
                VarcharType.VARCHAR.writeString(blockBuilder, value);
            }
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(2.0, DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

