/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public final class GenericLongFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(GenericLongFunction.class, (String)"apply", (Class[])new Class[]{LongUnaryOperator.class, Long.TYPE});
    private final LongUnaryOperator longUnaryOperator;

    GenericLongFunction(String suffix, LongUnaryOperator longUnaryOperator) {
        super(Signature.internalScalarFunction((String)("generic_long_" + Objects.requireNonNull(suffix, "suffix is null")), (TypeSignature)TypeSignature.parseTypeSignature((String)"bigint"), (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        this.longUnaryOperator = longUnaryOperator;
    }

    public boolean isHidden() {
        return true;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "generic long function for test";
    }

    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.longUnaryOperator);
        return new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    public static long apply(LongUnaryOperator longUnaryOperator, long value) {
        return longUnaryOperator.applyAsLong(value);
    }
}

