/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.testing.assertions.Assert;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class GroupByHashYieldAssertion {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));

    private GroupByHashYieldAssertion() {
    }

    public static List<Page> createPagesWithDistinctHashKeys(Type type, int pageCount, int positionCountPerPage) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)ImmutableList.of((Object)0), type);
        for (int i = 0; i < pageCount; ++i) {
            rowPagesBuilder.addSequencePage(positionCountPerPage, positionCountPerPage * i);
        }
        return rowPagesBuilder.build();
    }

    public static GroupByHashYieldResult finishOperatorWithYieldingGroupByHash(List<Page> input, Type hashKeyType, OperatorFactory operatorFactory, Function<Operator, Integer> getHashCapacity, long additionalMemoryInBytes) {
        Assertions.assertLessThan((Comparable)Long.valueOf(additionalMemoryInBytes), (Comparable)Long.valueOf(0x200000L), (String)"additionalMemoryInBytes should be a relatively small number");
        LinkedList<Page> result = new LinkedList<Page>();
        QueryId queryId = new QueryId("test_query");
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        QueryContext queryContext = new QueryContext(queryId, new DataSize(512.0, DataSize.Unit.MEGABYTE), new DataSize(1024.0, DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)EXECUTOR, SCHEDULED_EXECUTOR, new DataSize(512.0, DataSize.Unit.MEGABYTE), new SpillSpaceTracker(new DataSize(512.0, DataSize.Unit.MEGABYTE)));
        DriverContext driverContext = TestingTaskContext.createTaskContext((QueryContext)queryContext, (Executor)EXECUTOR, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = operatorFactory.createOperator(driverContext);
        int yieldCount = 0;
        long expectedReservedExtraBytes = 0L;
        for (Page page : input) {
            long newMemoryUsage;
            org.testng.Assert.assertTrue((boolean)operator.needsInput());
            long reservedMemoryInBytes = memoryPool.getFreeBytes() - additionalMemoryInBytes;
            memoryPool.reserve(queryId, "test", reservedMemoryInBytes);
            long oldMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            int oldCapacity = getHashCapacity.apply(operator);
            operator.addInput(page);
            Page output = operator.getOutput();
            if (output != null) {
                result.add(output);
            }
            if ((newMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage()) < new DataSize(4.0, DataSize.Unit.MEGABYTE).toBytes()) {
                memoryPool.free(queryId, "test", reservedMemoryInBytes);
                operator.getOutput();
                continue;
            }
            long actualIncreasedMemory = newMemoryUsage - oldMemoryUsage;
            if (operator.needsInput()) {
                org.testng.Assert.assertTrue((boolean)operator.getOperatorContext().isWaitingForMemory().isDone());
                org.testng.Assert.assertTrue((oldCapacity == getHashCapacity.apply(operator) ? 1 : 0) != 0);
                Assertions.assertLessThan((Comparable)Long.valueOf(actualIncreasedMemory), (Comparable)Long.valueOf(additionalMemoryInBytes));
                memoryPool.free(queryId, "test", reservedMemoryInBytes);
                continue;
            }
            ++yieldCount;
            org.testng.Assert.assertFalse((boolean)operator.getOperatorContext().isWaitingForMemory().isDone());
            Assert.assertEquals((long)oldCapacity, (long)getHashCapacity.apply(operator).intValue());
            expectedReservedExtraBytes = hashKeyType == BigintType.BIGINT ? (long)oldCapacity * 18L + page.getRetainedSizeInBytes() : (long)oldCapacity * 19L + page.getRetainedSizeInBytes();
            Assertions.assertBetweenInclusive((Comparable)Long.valueOf(actualIncreasedMemory), (Comparable)Long.valueOf(expectedReservedExtraBytes), (Comparable)Long.valueOf(expectedReservedExtraBytes + additionalMemoryInBytes));
            org.testng.Assert.assertNull((Object)operator.getOutput());
            memoryPool.free(queryId, "test", reservedMemoryInBytes);
            output = operator.getOutput();
            if (output != null) {
                result.add(output);
            }
            org.testng.Assert.assertTrue((boolean)operator.needsInput());
            Assertions.assertGreaterThan((Comparable)getHashCapacity.apply(operator), (Comparable)Integer.valueOf(oldCapacity));
            long rehashedMemoryUsage = operator.getOperatorContext().getDriverContext().getMemoryUsage();
            Assertions.assertBetweenInclusive((Comparable)Double.valueOf((double)rehashedMemoryUsage * 1.0 / (double)newMemoryUsage), (Comparable)Double.valueOf(0.99), (Comparable)Double.valueOf(1.01));
            org.testng.Assert.assertTrue((boolean)operator.needsInput());
        }
        result.addAll(OperatorAssertion.finishOperator(operator));
        return new GroupByHashYieldResult(yieldCount, expectedReservedExtraBytes, result);
    }

    public static final class GroupByHashYieldResult {
        private final int yieldCount;
        private final long maxReservedBytes;
        private final List<Page> output;

        public GroupByHashYieldResult(int yieldCount, long maxReservedBytes, List<Page> output) {
            this.yieldCount = yieldCount;
            this.maxReservedBytes = maxReservedBytes;
            this.output = Objects.requireNonNull(output, "output is null");
        }

        public int getYieldCount() {
            return this.yieldCount;
        }

        public long getMaxReservedBytes() {
            return this.maxReservedBytes;
        }

        public List<Page> getOutput() {
            return this.output;
        }
    }
}

