/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.ExceededMemoryLimitException;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DummySpillerFactory;
import io.prestosql.operator.GroupByHashYieldAssertion;
import io.prestosql.operator.HashAggregationOperator;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.SpillContext;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.builder.HashAggregationBuilder;
import io.prestosql.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.Spiller;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashAggregationOperator {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction LONG_AVERAGE = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("avg", FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}));
    private static final InternalAggregationFunction LONG_SUM = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("sum", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}));
    private static final InternalAggregationFunction COUNT = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[0]));
    private static final int MAX_BLOCK_SIZE_IN_BYTES = 65536;
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private JoinCompiler joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
    private DummySpillerFactory spillerFactory;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.spillerFactory = new DummySpillerFactory();
    }

    @DataProvider(name="hashEnabled")
    public static Object[][] hashEnabled() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider(name="hashEnabledAndMemoryLimitForMergeValues")
    public static Object[][] hashEnabledAndMemoryLimitForMergeValuesProvider() {
        return new Object[][]{{true, true, true, 8, Integer.MAX_VALUE}, {true, true, false, 8, Integer.MAX_VALUE}, {false, false, false, 0, 0}, {false, true, true, 0, 0}, {false, true, false, 0, 0}, {false, true, true, 8, 0}, {false, true, false, 8, 0}, {false, true, true, 8, Integer.MAX_VALUE}, {false, true, false, 8, Integer.MAX_VALUE}};
    }

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{VarcharType.VARCHAR}, {BigintType.BIGINT}};
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.spillerFactory = null;
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test(dataProvider="hashEnabledAndMemoryLimitForMergeValues")
    public void testHashAggregation(boolean hashEnabled, boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimitForMerge, long memoryLimitForMergeWithMemory) {
        int numberOfRows = 40000;
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        InternalAggregationFunction countVarcharColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        InternalAggregationFunction countBooleanColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        InternalAggregationFunction maxVarcharColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("max", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        List hashChannels = Ints.asList((int[])new int[]{1});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN});
        List<Page> input = rowPagesBuilder.addSequencePage(numberOfRows, 100, 0, 100000, 0, 500).addSequencePage(numberOfRows, 100, 0, 200000, 0, 500).addSequencePage(numberOfRows, 100, 0, 300000, 0, 500).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)LONG_AVERAGE.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)maxVarcharColumn.bind((List)ImmutableList.of((Object)2), Optional.empty()), (Object)countVarcharColumn.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)countBooleanColumn.bind((List)ImmutableList.of((Object)4), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), spillEnabled, DataSize.succinctBytes((long)memoryLimitForMerge), DataSize.succinctBytes((long)memoryLimitForMergeWithMemory), (SpillerFactory)this.spillerFactory, this.joinCompiler, false);
        DriverContext driverContext = this.createDriverContext(memoryLimitForMerge);
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT});
        for (int i = 0; i < numberOfRows; ++i) {
            expectedBuilder.row(new Object[]{Integer.toString(i), 3L, 3L * (long)i, (double)i, Integer.toString(300000 + i), 3L, 3L});
        }
        MaterializedResult expected = expectedBuilder.build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input, revokeMemoryWhenAddingPages);
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(pages.size()), (Comparable)Integer.valueOf(1), (String)"Expected more than one output page");
        OperatorAssertion.assertPagesEqualIgnoreOrder(driverContext, pages, expected, hashEnabled, Optional.of(hashChannels.size()));
        Assert.assertTrue((spillEnabled == this.spillerFactory.getSpillsCount() > 0L ? 1 : 0) != 0, (String)String.format("Spill state mismatch. Expected spill: %s, spill count: %s", spillEnabled, this.spillerFactory.getSpillsCount()));
    }

    @Test(dataProvider="hashEnabledAndMemoryLimitForMergeValues")
    public void testHashAggregationWithGlobals(boolean hashEnabled, boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimitForMerge, long memoryLimitForMergeWithMemory) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        InternalAggregationFunction countVarcharColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        InternalAggregationFunction countBooleanColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        InternalAggregationFunction maxVarcharColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("max", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        Optional<Integer> groupIdChannel = Optional.of(1);
        List groupByChannels = Ints.asList((int[])new int[]{1, 2});
        List globalAggregationGroupIds = Ints.asList((int[])new int[]{42, 49});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)groupByChannels, new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, BooleanType.BOOLEAN});
        List<Page> input = rowPagesBuilder.build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), groupByChannels, globalAggregationGroupIds, AggregationNode.Step.SINGLE, true, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)4), Optional.empty()), (Object)LONG_AVERAGE.bind((List)ImmutableList.of((Object)4), Optional.empty()), (Object)maxVarcharColumn.bind((List)ImmutableList.of((Object)2), Optional.empty()), (Object)countVarcharColumn.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)countBooleanColumn.bind((List)ImmutableList.of((Object)5), Optional.empty())), rowPagesBuilder.getHashChannel(), groupIdChannel, 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), spillEnabled, DataSize.succinctBytes((long)memoryLimitForMerge), DataSize.succinctBytes((long)memoryLimitForMergeWithMemory), (SpillerFactory)this.spillerFactory, this.joinCompiler, false);
        DriverContext driverContext = this.createDriverContext(memoryLimitForMerge);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{null, 42L, 0L, null, null, null, 0L, 0L}).row(new Object[]{null, 49L, 0L, null, null, null, 0L, 0L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, driverContext, input, expected, hashEnabled, Optional.of(groupByChannels.size()), revokeMemoryWhenAddingPages);
    }

    @Test(dataProvider="hashEnabledAndMemoryLimitForMergeValues")
    public void testHashAggregationMemoryReservation(boolean hashEnabled, boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimitForMerge, long memoryLimitForMergeWithMemory) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        InternalAggregationFunction arrayAggColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("array_agg", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(bigint)"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        List hashChannels = Ints.asList((int[])new int[]{1});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(10, 100, 0).addSequencePage(10, 200, 0).addSequencePage(10, 300, 0).build();
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(10.0, DataSize.Unit.MEGABYTE)).addPipelineContext(0, true, true, false).addDriverContext();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, true, (List)ImmutableList.of((Object)arrayAggColumn.bind((List)ImmutableList.of((Object)0), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), spillEnabled, DataSize.succinctBytes((long)memoryLimitForMerge), DataSize.succinctBytes((long)memoryLimitForMergeWithMemory), (SpillerFactory)this.spillerFactory, this.joinCompiler, false);
        Operator operator = operatorFactory.createOperator(driverContext);
        OperatorAssertion.toPages(operator, input.iterator(), revokeMemoryWhenAddingPages);
        Assert.assertEquals((long)operator.getOperatorContext().getOperatorStats().getUserMemoryReservation().toBytes(), (long)0L);
    }

    @Test(dataProvider="hashEnabled", expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Query exceeded per-node user memory limit of 10B.*")
    public void testMemoryLimit(boolean hashEnabled) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        InternalAggregationFunction maxVarcharColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("max", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        List hashChannels = Ints.asList((int[])new int[]{1});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(10, 100, 0, 100, 0).addSequencePage(10, 100, 0, 200, 0).addSequencePage(10, 100, 0, 300, 0).build();
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE)).addPipelineContext(0, true, true, false).addDriverContext();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)LONG_AVERAGE.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)maxVarcharColumn.bind((List)ImmutableList.of((Object)2), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), this.joinCompiler, false);
        OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
    }

    @Test(dataProvider="hashEnabledAndMemoryLimitForMergeValues")
    public void testHashBuilderResize(boolean hashEnabled, boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimitForMerge, long memoryLimitForMergeWithMemory) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1, 65536);
        VarcharType.VARCHAR.writeSlice(builder, Slices.allocate((int)200000));
        builder.build();
        List hashChannels = Ints.asList((int[])new int[]{0});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{VarcharType.VARCHAR});
        List<Page> input = rowPagesBuilder.addSequencePage(10, 100).addBlocksPage(builder.build()).addSequencePage(10, 100).build();
        DriverContext driverContext = this.createDriverContext(memoryLimitForMerge);
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), spillEnabled, DataSize.succinctBytes((long)memoryLimitForMerge), DataSize.succinctBytes((long)memoryLimitForMergeWithMemory), (SpillerFactory)this.spillerFactory, this.joinCompiler, false);
        OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input, revokeMemoryWhenAddingPages);
    }

    @Test(dataProvider="dataType")
    public void testMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type), (List)ImmutableList.of((Object)0), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty())), Optional.of(1), Optional.empty(), 1, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), this.joinCompiler, false);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, this::getHashCapacity, 1400000L);
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        int count = 0;
        for (Page page : result.getOutput()) {
            Assert.assertEquals((int)page.getChannelCount(), (int)3);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assert.assertEquals((long)page.getBlock(2).getLong(i, 0), (long)1L);
                ++count;
            }
        }
        Assert.assertEquals((int)count, (int)3600000);
    }

    @Test(dataProvider="hashEnabled", expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Query exceeded per-node user memory limit of 3MB.*")
    public void testHashBuilderResizeLimit(boolean hashEnabled) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1, 65536);
        VarcharType.VARCHAR.writeSlice(builder, Slices.allocate((int)5000000));
        builder.build();
        List hashChannels = Ints.asList((int[])new int[]{0});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{VarcharType.VARCHAR});
        List<Page> input = rowPagesBuilder.addSequencePage(10, 100).addBlocksPage(builder.build()).addSequencePage(10, 100).build();
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(3.0, DataSize.Unit.MEGABYTE)).addPipelineContext(0, true, true, false).addDriverContext();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), this.joinCompiler, false);
        OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
    }

    @Test(dataProvider="hashEnabled")
    public void testMultiSliceAggregationOutput(boolean hashEnabled) {
        int fixedWidthSize = 32;
        int multiSlicePositionCount = (int)(1572864.0 / (double)fixedWidthSize);
        List hashChannels = Ints.asList((int[])new int[]{1});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(multiSlicePositionCount, 0, 0).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_AVERAGE.bind((List)ImmutableList.of((Object)1), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), this.joinCompiler, false);
        Assert.assertEquals((int)OperatorAssertion.toPages((OperatorFactory)operatorFactory, this.createDriverContext(), input).size(), (int)2);
    }

    @Test(dataProvider="hashEnabled")
    public void testMultiplePartialFlushes(boolean hashEnabled) throws Exception {
        List hashChannels = Ints.asList((int[])new int[]{0});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)hashChannels, new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(500, 0).addSequencePage(500, 500).addSequencePage(500, 1000).addSequencePage(500, 1500).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.PARTIAL, (List)ImmutableList.of((Object)LONG_SUM.bind((List)ImmutableList.of((Object)0), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(1.0, DataSize.Unit.KILOBYTE)), this.joinCompiler, true);
        DriverContext driverContext = this.createDriverContext(1024L);
        try (Operator operator = operatorFactory.createOperator(driverContext);){
            Page output;
            List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).addSequencePage(2000, 0, 0).build();
            MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).pages(expectedPages).build();
            Iterator<Page> inputIterator = input.iterator();
            while (operator.needsInput() && inputIterator.hasNext()) {
                operator.addInput(inputIterator.next());
            }
            Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
            Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
            List<Page> outputPages = new ArrayList<Page>();
            while ((output = operator.getOutput()) != null) {
                outputPages.add(output);
            }
            Assert.assertTrue((!outputPages.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)operator.needsInput());
            outputPages.addAll(OperatorAssertion.toPages(operator, inputIterator));
            if (hashEnabled) {
                outputPages = OperatorAssertion.dropChannel(outputPages, (List<Integer>)ImmutableList.of((Object)1));
            }
            MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), expected.getTypes(), outputPages);
            Assert.assertEquals((Collection)actual.getTypes(), (Collection)expected.getTypes());
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        }
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    @Test
    public void testMergeWithMemorySpill() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT});
        int smallPagesSpillThresholdSize = 150000;
        List<Page> input = rowPagesBuilder.addSequencePage(smallPagesSpillThresholdSize, 0).addSequencePage(10, smallPagesSpillThresholdSize).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)LONG_SUM.bind((List)ImmutableList.of((Object)0), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 1, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), true, new DataSize((double)smallPagesSpillThresholdSize, DataSize.Unit.BYTE), DataSize.succinctBytes((long)Integer.MAX_VALUE), (SpillerFactory)this.spillerFactory, this.joinCompiler, false);
        DriverContext driverContext = this.createDriverContext(smallPagesSpillThresholdSize);
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        for (int i = 0; i < smallPagesSpillThresholdSize + 10; ++i) {
            resultBuilder.row(new Object[]{(long)i, (long)i});
        }
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, driverContext, input, resultBuilder.build());
    }

    @Test
    public void testSpillerFailure() {
        block2: {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            InternalAggregationFunction maxVarcharColumn = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("max", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
            List hashChannels = Ints.asList((int[])new int[]{1});
            ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
            RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)hashChannels, (Iterable<Type>)types);
            List<Page> input = rowPagesBuilder.addSequencePage(10, 100, 0, 100, 0).addSequencePage(10, 100, 0, 200, 0).addSequencePage(10, 100, 0, 300, 0).build();
            DriverContext driverContext = TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setQueryMaxMemory(DataSize.valueOf((String)"7MB")).setMemoryPoolSize(DataSize.valueOf((String)"1GB")).build().addPipelineContext(0, true, true, false).addDriverContext();
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)LONG_AVERAGE.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)maxVarcharColumn.bind((List)ImmutableList.of((Object)2), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), true, DataSize.succinctBytes((long)8L), DataSize.succinctBytes((long)Integer.MAX_VALUE), (SpillerFactory)new FailingSpillerFactory(), this.joinCompiler, false);
            try {
                OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
                Assert.fail((String)"An exception was expected");
            }
            catch (RuntimeException expected) {
                if (Strings.nullToEmpty((String)expected.getMessage()).matches(".* Failed to spill")) break block2;
                Assert.fail((String)"Exception other than expected was thrown", (Throwable)expected);
            }
        }
    }

    @Test
    public void testMemoryTracking() throws Exception {
        this.testMemoryTracking(false);
        this.testMemoryTracking(true);
    }

    private void testMemoryTracking(boolean useSystemMemory) throws Exception {
        List hashChannels = Ints.asList((int[])new int[]{0});
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)hashChannels, new Type[]{BigintType.BIGINT});
        Page input = (Page)Iterables.getOnlyElement(rowPagesBuilder.addSequencePage(500, 0).build());
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT), hashChannels, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)LONG_SUM.bind((List)ImmutableList.of((Object)0), Optional.empty())), rowPagesBuilder.getHashChannel(), Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), this.joinCompiler, useSystemMemory);
        DriverContext driverContext = this.createDriverContext(1024L);
        try (Operator operator = operatorFactory.createOperator(driverContext);){
            Assert.assertTrue((boolean)operator.needsInput());
            operator.addInput(input);
            if (useSystemMemory) {
                Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
                Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
            } else {
                Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
                Assertions.assertThat((long)driverContext.getMemoryUsage()).isGreaterThan(0L);
            }
            OperatorAssertion.toPages(operator, Collections.emptyIterator());
        }
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    private DriverContext createDriverContext() {
        return this.createDriverContext(Integer.MAX_VALUE);
    }

    private DriverContext createDriverContext(long memoryLimit) {
        return TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(DataSize.succinctBytes((long)memoryLimit)).build().addPipelineContext(0, true, true, false).addDriverContext();
    }

    private int getHashCapacity(Operator operator) {
        Assert.assertTrue((boolean)(operator instanceof HashAggregationOperator));
        HashAggregationBuilder aggregationBuilder = ((HashAggregationOperator)operator).getAggregationBuilder();
        if (aggregationBuilder == null) {
            return 0;
        }
        Assert.assertTrue((boolean)(aggregationBuilder instanceof InMemoryHashAggregationBuilder));
        return ((InMemoryHashAggregationBuilder)aggregationBuilder).getCapacity();
    }

    private static class FailingSpillerFactory
    implements SpillerFactory {
        private FailingSpillerFactory() {
        }

        public Spiller create(List<Type> types, SpillContext spillContext, AggregatedMemoryContext memoryContext) {
            return new Spiller(){

                public ListenableFuture<?> spill(Iterator<Page> pageIterator) {
                    return Futures.immediateFailedFuture((Throwable)new IOException("Failed to spill"));
                }

                public List<Iterator<Page>> getSpills() {
                    return ImmutableList.of();
                }

                public void close() {
                }
            };
        }
    }
}

