/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.operator.Driver;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.NestedLoopBuildOperator;
import io.prestosql.operator.NestedLoopJoinOperator;
import io.prestosql.operator.NestedLoopJoinPagesSupplier;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.ValuesOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNestedLoopJoinOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNestedLoopJoin() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(3, 20, 30, 40);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(2, 0, 1000, 2000).build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat(probePages.getTypes(), buildPages.getTypes())).row(new Object[]{"0", 1000L, 2000L, "20", 30L, 40L}).row(new Object[]{"0", 1000L, 2000L, "21", 31L, 41L}).row(new Object[]{"0", 1000L, 2000L, "22", 32L, 42L}).row(new Object[]{"1", 1001L, 2001L, "20", 30L, 40L}).row(new Object[]{"1", 1001L, 2001L, "21", 31L, 41L}).row(new Object[]{"1", 1001L, 2001L, "22", 32L, 42L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
        buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(2, 20, 30, 40);
        joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        probeInput = probePages.addSequencePage(3, 0, 1000, 2000).build();
        expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat(probePages.getTypes(), buildPages.getTypes())).row(new Object[]{"0", 1000L, 2000L, "20", 30L, 40L}).row(new Object[]{"1", 1001L, 2001L, "20", 30L, 40L}).row(new Object[]{"2", 1002L, 2002L, "20", 30L, 40L}).row(new Object[]{"0", 1000L, 2000L, "21", 31L, 41L}).row(new Object[]{"1", 1001L, 2001L, "21", 31L, 41L}).row(new Object[]{"2", 1002L, 2002L, "21", 31L, 41L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCrossJoinWithNullProbe() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").row("b");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row(new Object[]{null}).row(new Object[]{null}).row("A").row("B").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{null, "a"}).row(new Object[]{null, "a"}).row(new Object[]{"A", "a"}).row(new Object[]{"B", "a"}).row(new Object[]{"A", "b"}).row(new Object[]{null, "b"}).row(new Object[]{null, "b"}).row(new Object[]{"A", "b"}).row(new Object[]{"B", "b"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCrossJoinWithNullBuild() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{"A", null}).row(new Object[]{"A", null}).row(new Object[]{"A", "a"}).row(new Object[]{"A", "b"}).row(new Object[]{"B", "a"}).row(new Object[]{"B", null}).row(new Object[]{"B", null}).row(new Object[]{"B", "a"}).row(new Object[]{"B", "b"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCrossJoinWithNullOnBothSides() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row("b").row("c").row(new Object[]{null});
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").row(new Object[]{null}).row("C").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{"A", null}).row(new Object[]{"A", "b"}).row(new Object[]{"A", "c"}).row(new Object[]{"A", null}).row(new Object[]{"B", "a"}).row(new Object[]{"B", null}).row(new Object[]{"B", "b"}).row(new Object[]{"B", "c"}).row(new Object[]{"B", null}).row(new Object[]{null, "a"}).row(new Object[]{null, null}).row(new Object[]{null, "b"}).row(new Object[]{null, "c"}).row(new Object[]{null, null}).row(new Object[]{"C", "a"}).row(new Object[]{"C", null}).row(new Object[]{"C", "b"}).row(new Object[]{"C", "c"}).row(new Object[]{"C", null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testBuildMultiplePages() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("a").pageBreak().row(new Object[]{null}).row("b").row("c").pageBreak().row("d");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"A", "a"}).row(new Object[]{"B", "a"}).row(new Object[]{"A", null}).row(new Object[]{"A", "b"}).row(new Object[]{"A", "c"}).row(new Object[]{"B", null}).row(new Object[]{"B", "b"}).row(new Object[]{"B", "c"}).row(new Object[]{"A", "d"}).row(new Object[]{"B", "d"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testProbeMultiplePages() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("A").row("B");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").pageBreak().row(new Object[]{null}).row("b").row("c").pageBreak().row("d").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"a", "A"}).row(new Object[]{"a", "B"}).row(new Object[]{null, "A"}).row(new Object[]{"b", "A"}).row(new Object[]{"c", "A"}).row(new Object[]{null, "B"}).row(new Object[]{"b", "B"}).row(new Object[]{"c", "B"}).row(new Object[]{"d", "A"}).row(new Object[]{"d", "B"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testProbeAndBuildMultiplePages() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("A").row("B").pageBreak().row("C");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").pageBreak().row(new Object[]{null}).row("b").row("c").pageBreak().row("d").build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).row(new Object[]{"a", "A"}).row(new Object[]{"a", "B"}).row(new Object[]{"a", "C"}).row(new Object[]{null, "A"}).row(new Object[]{"b", "A"}).row(new Object[]{"c", "A"}).row(new Object[]{null, "B"}).row(new Object[]{"b", "B"}).row(new Object[]{"c", "B"}).row(new Object[]{null, "C"}).row(new Object[]{"b", "C"}).row(new Object[]{"c", "C"}).row(new Object[]{"d", "A"}).row(new Object[]{"d", "B"}).row(new Object[]{"d", "C"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testEmptyProbePage() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row("A").row("B").pageBreak().row("C");
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.pageBreak().build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testEmptyBuildPage() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).pageBreak();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("A").row("B").pageBreak().build();
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = TestNestedLoopJoinOperator.newJoinOperatorFactoryWithCompletedBuild(taskContext, buildPages);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, buildPages.getTypes())).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected);
    }

    @Test
    public void testCount() {
        Page buildPage = new Page(100, new Block[0]);
        Page probePage = new Page(45, new Block[0]);
        NestedLoopJoinOperator.NestedLoopPageBuilder resultPageBuilder = new NestedLoopJoinOperator.NestedLoopPageBuilder(probePage, buildPage);
        Assert.assertTrue((boolean)resultPageBuilder.hasNext(), (String)"There should be at least one page.");
        long result = 0L;
        while (resultPageBuilder.hasNext()) {
            result += (long)resultPageBuilder.next().getPositionCount();
        }
        Assert.assertEquals((long)result, (long)4500L);
        buildPage = new Page(0x7FFFFFF5, new Block[0]);
        resultPageBuilder = new NestedLoopJoinOperator.NestedLoopPageBuilder(probePage, buildPage);
        result = 0L;
        while (resultPageBuilder.hasNext()) {
            result += (long)resultPageBuilder.next().getPositionCount();
        }
        Assert.assertEquals((long)96636763665L, (long)result);
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static NestedLoopJoinOperator.NestedLoopJoinOperatorFactory newJoinOperatorFactoryWithCompletedBuild(TaskContext taskContext, RowPagesBuilder buildPages) {
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("test"), buildPages.build());
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> new NestedLoopJoinPagesSupplier(), buildPages.getTypes());
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(1, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        NestedLoopJoinOperator.NestedLoopJoinOperatorFactory joinOperatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        Operator valuesOperator = valuesOperatorFactory.createOperator(driverContext);
        Operator nestedLoopBuildOperator = nestedLoopBuildOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)valuesOperator, (Operator[])new Operator[]{nestedLoopBuildOperator});
        valuesOperatorFactory.noMoreOperators();
        nestedLoopBuildOperatorFactory.noMoreOperators();
        while (nestedLoopBuildOperator.isBlocked().isDone()) {
            driver.process();
        }
        return joinOperatorFactory;
    }
}

