/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.TestingOperatorContext;
import io.prestosql.spi.Page;
import io.prestosql.testing.assertions.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOperatorAssertion {
    private ScheduledExecutorService executor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testToPagesWithBlockedOperator() {
        BlockedOperator operator = new BlockedOperator(Duration.valueOf((String)"15 ms"));
        List<Page> pages = OperatorAssertion.toPages(operator, Collections.emptyIterator());
        Assert.assertEquals(pages, (Collection)ImmutableList.of());
    }

    private class BlockedOperator
    implements Operator {
        private final Duration unblockAfter;
        private final OperatorContext operatorContext;
        private ListenableFuture<?> isBlocked = NOT_BLOCKED;

        public BlockedOperator(Duration unblockAfter) {
            this.unblockAfter = Objects.requireNonNull(unblockAfter, "unblockAfter is null");
            this.operatorContext = TestingOperatorContext.create(TestOperatorAssertion.this.executor);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public ListenableFuture<?> isBlocked() {
            return this.isBlocked;
        }

        public boolean needsInput() {
            return false;
        }

        public void addInput(Page page) {
            throw new UnsupportedOperationException();
        }

        public void finish() {
            if (this.isBlocked == NOT_BLOCKED) {
                SettableFuture isBlocked;
                this.isBlocked = isBlocked = SettableFuture.create();
                TestOperatorAssertion.this.executor.schedule(() -> isBlocked.set(null), this.unblockAfter.toMillis(), TimeUnit.MILLISECONDS);
            }
        }

        public boolean isFinished() {
            return this.isBlocked != NOT_BLOCKED && this.isBlocked.isDone();
        }

        public Page getOutput() {
            return null;
        }
    }
}

