/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.RowPagesBuilder;
import io.prestosql.SequencePageBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.Split;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.GenericLongFunction;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.ScanFilterAndProjectOperator;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.index.PageRecordSet;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.project.TestPageProcessor;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingSplit;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.testing.assertions.Assert;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.testng.annotations.Test;

public class TestScanFilterAndProjectOperator
extends AbstractTestFunctions {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)this.metadata, new PageFunctionCompiler((Metadata)this.metadata, 0));
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));

    @Test
    public void testPageSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageSourceMergeOutput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).build();
        CallExpression filter = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.of(filter), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(Optional.of(filter), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new FixedPageSource((Iterable)input), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(64.0, DataSize.Unit.KILOBYTE), 2);
        SourceOperator operator = factory.createOperator(this.newDriverContext());
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        List<Page> actual = TestScanFilterAndProjectOperator.toPages((Operator)operator);
        Assert.assertEquals((int)actual.size(), (int)1);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(10L).row(10L).row(10L).row(10L).build();
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actual.get(0), expected.get(0));
    }

    @Test
    public void testPageSourceLazyLoad() {
        Block inputBlock = BlockAssertions.createLongSequenceBlock(0, 100);
        Page input = new Page(100, new Block[]{inputBlock, new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestPageProcessor.SelectAllFilter()), (List)ImmutableList.of((Object)new TestPageProcessor.LazyPagePageProjection()));
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new SinglePagePageSource(input), cursorProcessor, () -> pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{inputBlock})));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testRecordCursorSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)VarcharType.VARCHAR), input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageYield() {
        int totalRows = 1000;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), totalRows, 1);
        DriverContext driverContext = this.newDriverContext();
        int totalColumns = 20;
        ImmutableList.Builder functions = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            functions.add((Object)new GenericLongFunction("page_col" + i, value -> {
                driverContext.getYieldSignal().forceYieldForTesting();
                return value;
            }));
        }
        Metadata metadata = this.functionAssertions.getMetadata();
        metadata.getFunctionRegistry().addFunctions((List)functions.build());
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(metadata, new PageFunctionCompiler(metadata, 0));
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            projections.add((Object)Expressions.call((Signature)Signature.internalScalarFunction((String)("generic_long_page_col" + i), (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        }
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections.build(), (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections.build(), 8192);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        for (int i = 1; i <= totalRows * totalColumns; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            Page page = operator.getOutput();
            if (i == totalColumns) {
                org.testng.Assert.assertNotNull((Object)page);
                Assert.assertEquals((int)page.getPositionCount(), (int)totalRows);
                Assert.assertEquals((int)page.getChannelCount(), (int)totalColumns);
                for (int j = 0; j < totalColumns; ++j) {
                    Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, page.getBlock(j)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
                }
            } else {
                org.testng.Assert.assertNull((Object)page);
            }
            driverContext.getYieldSignal().reset();
        }
    }

    @Test
    public void testRecordCursorYield() {
        int length = 15;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), length, 0);
        DriverContext driverContext = this.newDriverContext();
        Metadata metadata = this.functionAssertions.getMetadata();
        metadata.getFunctionRegistry().addFunctions((List)ImmutableList.of((Object)((Object)new GenericLongFunction("record_cursor", value -> {
            driverContext.getYieldSignal().forceYieldForTesting();
            return value;
        }))));
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(metadata, new PageFunctionCompiler(metadata, 0));
        ImmutableList projections = ImmutableList.of((Object)Expressions.call((Signature)Signature.internalScalarFunction((String)"generic_long_record_cursor", (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)BigintType.BIGINT), input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        for (int i = 0; i < length; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            org.testng.Assert.assertNull((Object)operator.getOutput());
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
        Page output = operator.getOutput();
        driverContext.getYieldSignal().reset();
        org.testng.Assert.assertNotNull((Object)output);
        Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, output.getBlock(0)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
    }

    private static List<Page> toPages(Operator operator) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int nullPages = 0;
        while (!operator.isFinished()) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) {
                org.testng.Assert.assertTrue((nullPages < 1000000 ? 1 : 0) != 0, (String)"Too many null pages; infinite loop?");
                ++nullPages;
                continue;
            }
            outputPages.add((Object)outputPage);
            nullPages = 0;
        }
        return outputPages.build();
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    public static class SinglePagePageSource
    implements ConnectorPageSource {
        private Page page;

        public SinglePagePageSource(Page page) {
            this.page = page;
        }

        public void close() {
            this.page = null;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public long getSystemMemoryUsage() {
            return 0L;
        }

        public boolean isFinished() {
            return this.page == null;
        }

        public Page getNextPage() {
            Page page = this.page;
            this.page = null;
            return page;
        }
    }
}

