/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.ExceededMemoryLimitException;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.TestWorkProcessorOperator;
import io.prestosql.operator.TopNOperator;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTopNOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider(name="useWorkProcessorOperator")
    public static Object[][] useWorkProcessorOperator() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="useWorkProcessorOperator")
    public void testSingleFieldKey(boolean useWorkProcessorOperator) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).pageBreak().row(5L, 0.5).row(4L, 0.41).row(6L, 0.6).pageBreak().build();
        OperatorFactory operatorFactory = this.topNOperatorFactory(useWorkProcessorOperator, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{6L, 0.6}).row(new Object[]{5L, 0.5}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test(dataProvider="useWorkProcessorOperator")
    public void testMultiFieldKey(boolean useWorkProcessorOperator) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row("a", 1L).row("b", 2L).pageBreak().row("f", 3L).row("a", 4L).pageBreak().row("d", 5L).row("d", 7L).row("e", 6L).build();
        OperatorFactory operatorFactory = this.topNOperatorFactory(useWorkProcessorOperator, (List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), 3, (List<Integer>)ImmutableList.of((Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.DESC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"f", 3L}).row(new Object[]{"e", 6L}).row(new Object[]{"d", 7L}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test(dataProvider="useWorkProcessorOperator")
    public void testReverseOrder(boolean useWorkProcessorOperator) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).pageBreak().row(5L, 0.5).row(4L, 0.41).row(6L, 0.6).pageBreak().build();
        OperatorFactory operatorFactory = this.topNOperatorFactory(useWorkProcessorOperator, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{-1L, -0.1}).row(new Object[]{1L, 0.1}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test(dataProvider="useWorkProcessorOperator")
    public void testLimitZero(boolean useWorkProcessorOperator) throws Exception {
        OperatorFactory factory = this.topNOperatorFactory(useWorkProcessorOperator, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 0, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST));
        try (Operator operator = factory.createOperator(this.driverContext);){
            Assert.assertNull((Object)operator.getOutput());
            Assert.assertTrue((boolean)operator.isFinished());
            Assert.assertFalse((boolean)operator.needsInput());
            Assert.assertNull((Object)operator.getOutput());
        }
    }

    @Test(dataProvider="useWorkProcessorOperator")
    public void testExceedMemoryLimit(boolean useWorkProcessorOperator) throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).build();
        DriverContext smallDiverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(1.0, DataSize.Unit.BYTE)).addPipelineContext(0, true, true, false).addDriverContext();
        OperatorFactory operatorFactory = this.topNOperatorFactory(useWorkProcessorOperator, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 100, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        try (Operator operator = operatorFactory.createOperator(smallDiverContext);){
            operator.addInput(input.get(0));
            operator.getOutput();
            Assert.fail((String)"must fail because of exceeding local memory limit");
        }
        catch (ExceededMemoryLimitException exceededMemoryLimitException) {
            // empty catch block
        }
    }

    private OperatorFactory topNOperatorFactory(boolean workProcessorOperator, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Object factory = new TopNOperator.TopNOperatorFactory(0, new PlanNodeId("test"), types, n, sortChannels, sortOrders);
        if (workProcessorOperator) {
            factory = new TestWorkProcessorOperator.TestWorkProcessorOperatorFactory(99, new PlanNodeId("test"), (WorkProcessorOperatorFactory)factory);
        }
        return factory;
    }
}

