/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Objects;

public class TestWorkProcessorOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final WorkProcessor<Page> pages;
    private boolean noMoreInput;
    private Page inputPage;

    private TestWorkProcessorOperator(OperatorContext operatorContext, WorkProcessorOperatorFactory workProcessorOperatorFactory) {
        this.operatorContext = operatorContext;
        this.pages = workProcessorOperatorFactory.create(operatorContext.getSession(), operatorContext.getOperatorMemoryContext(), operatorContext.getDriverContext().getYieldSignal(), WorkProcessor.create((WorkProcessor.Process)new Pages())).getOutputPages();
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public boolean needsInput() {
        return !this.noMoreInput && !this.isFinished() && this.inputPage == null;
    }

    public void addInput(Page page) {
        this.inputPage = page;
    }

    public Page getOutput() {
        if (!this.pages.process()) {
            return null;
        }
        if (this.pages.isFinished()) {
            return null;
        }
        return (Page)this.pages.getResult();
    }

    public void finish() {
        this.noMoreInput = true;
    }

    public ListenableFuture<?> isBlocked() {
        if (!this.pages.isBlocked()) {
            return NOT_BLOCKED;
        }
        return this.pages.getBlockedFuture();
    }

    public boolean isFinished() {
        return this.pages.isFinished();
    }

    static class TestWorkProcessorOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final WorkProcessorOperatorFactory workProcessorOperatorFactory;
        private boolean closed;

        TestWorkProcessorOperatorFactory(int operatorId, PlanNodeId planNodeId, WorkProcessorOperatorFactory workProcessorOperatorFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.workProcessorOperatorFactory = Objects.requireNonNull(workProcessorOperatorFactory, "workProcessorOperatorFactory is null");
        }

        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TestWorkProcessorOperator.class.getSimpleName());
            return new TestWorkProcessorOperator(operatorContext, this.workProcessorOperatorFactory);
        }

        public void noMoreOperators() {
            this.closed = true;
        }

        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException();
        }
    }

    private class Pages
    implements WorkProcessor.Process<Page> {
        private Pages() {
        }

        public WorkProcessor.ProcessState<Page> process() {
            if (TestWorkProcessorOperator.this.noMoreInput) {
                return WorkProcessor.ProcessState.finished();
            }
            if (TestWorkProcessorOperator.this.inputPage == null) {
                return WorkProcessor.ProcessState.yield();
            }
            Page page = TestWorkProcessorOperator.this.inputPage;
            TestWorkProcessorOperator.this.inputPage = null;
            return WorkProcessor.ProcessState.ofResult((Object)page);
        }
    }
}

