/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.metadata.Split;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.SourceOperatorFactory;
import io.prestosql.operator.TestingOperatorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorAssertion;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.operator.WorkProcessorPipelineSourceOperator;
import io.prestosql.operator.WorkProcessorSourceOperator;
import io.prestosql.operator.WorkProcessorSourceOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingSplit;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWorkProcessorPipelineSourceOperator {
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testWorkProcessorPipelineSourceOperator() {
        Split split = this.createSplit();
        Page page1 = this.createPage(1);
        Page page2 = this.createPage(2);
        Page page3 = this.createPage(3);
        Page page4 = this.createPage(4);
        Page page5 = this.createPage(5);
        WorkProcessor.Transformation sourceOperatorPages = WorkProcessorAssertion.transformationFrom(ImmutableList.of(WorkProcessorAssertion.Transform.of(Optional.of(split), WorkProcessor.TransformationState.ofResult((Object)page1, (boolean)false)), WorkProcessorAssertion.Transform.of(Optional.of(split), WorkProcessor.TransformationState.ofResult((Object)page2, (boolean)true))));
        WorkProcessor.Transformation firstOperatorPages = WorkProcessorAssertion.transformationFrom(ImmutableList.of(WorkProcessorAssertion.Transform.of(Optional.of(page1), WorkProcessor.TransformationState.ofResult((Object)page3, (boolean)true)), WorkProcessorAssertion.Transform.of(Optional.of(page2), WorkProcessor.TransformationState.ofResult((Object)page4, (boolean)false)), WorkProcessorAssertion.Transform.of(Optional.of(page2), WorkProcessor.TransformationState.finished())));
        SettableFuture blockedFuture = SettableFuture.create();
        WorkProcessor.Transformation secondOperatorPages = WorkProcessorAssertion.transformationFrom(ImmutableList.of(WorkProcessorAssertion.Transform.of(Optional.of(page3), WorkProcessor.TransformationState.ofResult((Object)page5, (boolean)true)), WorkProcessorAssertion.Transform.of(Optional.of(page4), WorkProcessor.TransformationState.needsMoreData()), WorkProcessorAssertion.Transform.of(Optional.empty(), WorkProcessor.TransformationState.blocked((ListenableFuture)blockedFuture))));
        TestWorkProcessorSourceOperatorFactory sourceOperatorFactory = new TestWorkProcessorSourceOperatorFactory(1, new PlanNodeId("1"), sourceOperatorPages);
        TestWorkProcessorOperatorFactory firstOperatorFactory = new TestWorkProcessorOperatorFactory(2, firstOperatorPages);
        TestWorkProcessorOperatorFactory secondOperatorFactory = new TestWorkProcessorOperatorFactory(3, secondOperatorPages);
        SourceOperatorFactory pipelineOperatorFactory = (SourceOperatorFactory)Iterables.getOnlyElement((Iterable)WorkProcessorPipelineSourceOperator.convertOperators((int)99, (List)ImmutableList.of((Object)sourceOperatorFactory, (Object)firstOperatorFactory, (Object)secondOperatorFactory)));
        DriverContext driverContext = TestingOperatorContext.create(this.scheduledExecutor).getDriverContext();
        SourceOperator pipelineOperator = pipelineOperatorFactory.createOperator(driverContext);
        sourceOperatorFactory.sourceOperator.memoryTrackingContext.localUserMemoryContext().setBytes(123L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)123L);
        Assert.assertNull((Object)pipelineOperator.getOutput());
        Assert.assertFalse((boolean)pipelineOperator.isBlocked().isDone());
        pipelineOperator.addSplit(split);
        Assert.assertTrue((boolean)pipelineOperator.isBlocked().isDone());
        Assert.assertEquals((Object)pipelineOperator.getOutput(), (Object)page5);
        driverContext.getYieldSignal().forceYieldForTesting();
        Assert.assertNull((Object)pipelineOperator.getOutput());
        driverContext.getYieldSignal().resetYieldForTesting();
        Assert.assertNull((Object)pipelineOperator.getOutput());
        Assert.assertFalse((boolean)pipelineOperator.isBlocked().isDone());
        Assert.assertTrue((boolean)sourceOperatorFactory.sourceOperator.closed);
        Assert.assertTrue((boolean)firstOperatorFactory.operator.closed);
        Assert.assertFalse((boolean)secondOperatorFactory.operator.closed);
        pipelineOperator.finish();
        Assert.assertFalse((boolean)pipelineOperator.isFinished());
        Assert.assertTrue((boolean)secondOperatorFactory.operator.closed);
        blockedFuture.set(null);
        Assert.assertTrue((boolean)pipelineOperator.isBlocked().isDone());
        Assert.assertNull((Object)pipelineOperator.getOutput());
        Assert.assertTrue((boolean)pipelineOperator.isFinished());
    }

    private Split createSplit() {
        return new Split(new CatalogName("catalog_name"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide());
    }

    private Page createPage(int pageNumber) {
        return (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(1, pageNumber).build());
    }

    private class TestWorkProcessorOperator
    implements WorkProcessorOperator {
        final WorkProcessor<Page> pages;
        boolean closed;

        TestWorkProcessorOperator(WorkProcessor<Page> pages) {
            this.pages = pages;
        }

        public WorkProcessor<Page> getOutputPages() {
            return this.pages;
        }

        public void close() {
            this.closed = true;
        }
    }

    private class TestWorkProcessorOperatorFactory
    implements WorkProcessorOperatorFactory,
    OperatorFactory {
        final int operatorId;
        final WorkProcessor.Transformation<Page, Page> transformation;
        TestWorkProcessorOperator operator;

        TestWorkProcessorOperatorFactory(int operatorId, WorkProcessor.Transformation<Page, Page> transformation) {
            this.operatorId = operatorId;
            this.transformation = transformation;
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        public WorkProcessorOperator create(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Page> sourcePages) {
            Assert.assertNull((Object)this.operator, (String)"source operator already created");
            this.operator = new TestWorkProcessorOperator((WorkProcessor<Page>)sourcePages.transform(this.transformation));
            return this.operator;
        }

        public Operator createOperator(DriverContext driverContext) {
            throw new UnsupportedOperationException();
        }

        public void noMoreOperators() {
            throw new UnsupportedOperationException();
        }

        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException();
        }
    }

    private class TestWorkProcessorSourceOperator
    implements WorkProcessorSourceOperator {
        final WorkProcessor<Page> pages;
        boolean closed;
        MemoryTrackingContext memoryTrackingContext;

        TestWorkProcessorSourceOperator(WorkProcessor<Page> pages, MemoryTrackingContext memoryTrackingContext) {
            this.pages = pages;
            this.memoryTrackingContext = memoryTrackingContext;
        }

        public Supplier<Optional<UpdatablePageSource>> getUpdatablePageSourceSupplier() {
            return Optional::empty;
        }

        public WorkProcessor<Page> getOutputPages() {
            return this.pages;
        }

        public void close() {
            this.closed = true;
        }
    }

    private class TestWorkProcessorSourceOperatorFactory
    implements WorkProcessorSourceOperatorFactory,
    SourceOperatorFactory {
        final int operatorId;
        final PlanNodeId sourceId;
        final WorkProcessor.Transformation<Split, Page> transformation;
        TestWorkProcessorSourceOperator sourceOperator;

        TestWorkProcessorSourceOperatorFactory(int operatorId, PlanNodeId sourceId, WorkProcessor.Transformation<Split, Page> transformation) {
            this.operatorId = operatorId;
            this.sourceId = sourceId;
            this.transformation = transformation;
        }

        public int getOperatorId() {
            return this.operatorId;
        }

        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        public WorkProcessorSourceOperator create(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Split> splits) {
            Assert.assertNull((Object)this.sourceOperator, (String)"source operator already created");
            this.sourceOperator = new TestWorkProcessorSourceOperator((WorkProcessor<Page>)splits.transform(this.transformation).yielding(() -> ((DriverYieldSignal)yieldSignal).isSet()), memoryTrackingContext);
            return this.sourceOperator;
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            throw new UnsupportedOperationException();
        }

        public void noMoreOperators() {
            throw new UnsupportedOperationException();
        }
    }
}

