/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.util.concurrent.MoreExecutors;
import io.prestosql.Session;
import io.prestosql.execution.Lifespan;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.PipelineContext;
import io.prestosql.operator.TaskContext;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.TestingTaskContext;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class TestingOperatorContext {
    public static OperatorContext create(ScheduledExecutorService scheduledExecutor) {
        Executor executor = MoreExecutors.directExecutor();
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)executor, (ScheduledExecutorService)scheduledExecutor, (Session)TestingSession.testSessionBuilder().build());
        MemoryTrackingContext pipelineMemoryContext = new MemoryTrackingContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        PipelineContext pipelineContext = new PipelineContext(1, taskContext, executor, scheduledExecutor, pipelineMemoryContext, false, false, false);
        DriverContext driverContext = new DriverContext(pipelineContext, executor, scheduledExecutor, pipelineMemoryContext, Lifespan.taskWide());
        OperatorContext operatorContext = driverContext.addOperatorContext(1, new PlanNodeId("test"), "operator type");
        return operatorContext;
    }

    private TestingOperatorContext() {
    }
}

