/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.Lists;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.metadata.FunctionExtractor;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.TypeRegistry;
import java.util.Collection;
import java.util.List;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestAggregationFunction {
    protected TypeRegistry typeRegistry;
    protected FunctionRegistry functionRegistry;

    @BeforeClass
    public final void initTestAggregationFunction() {
        this.typeRegistry = new TypeRegistry();
        this.functionRegistry = new FunctionRegistry((TypeManager)this.typeRegistry, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)this.typeRegistry, new BlockEncoding[0]), new FeaturesConfig());
    }

    @AfterClass(alwaysRun=true)
    public final void destroyTestAggregationFunction() {
        this.functionRegistry = null;
        this.typeRegistry = null;
    }

    public abstract Block[] getSequenceBlocks(int var1, int var2);

    protected void registerFunctions(Plugin plugin) {
        this.functionRegistry.addFunctions(FunctionExtractor.extractFunctions((Collection)plugin.getFunctions()));
    }

    protected void registerTypes(Plugin plugin) {
        for (Type type : plugin.getTypes()) {
            this.typeRegistry.addType(type);
        }
    }

    protected final InternalAggregationFunction getFunction() {
        List parameterTypes = TypeSignatureProvider.fromTypeSignatures((List)Lists.transform(this.getFunctionParameterTypes(), TypeSignature::parseTypeSignature));
        Signature signature = this.functionRegistry.resolveFunction(QualifiedName.of((String)this.getFunctionName()), parameterTypes);
        return this.functionRegistry.getAggregateFunctionImplementation(signature);
    }

    protected abstract String getFunctionName();

    protected abstract List<String> getFunctionParameterTypes();

    public abstract Object getExpectedValue(int var1, int var2);

    public Object getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        return this.getExpectedValue(start, length);
    }

    @Test
    public void testNoPositions() {
        this.testAggregation(this.getExpectedValue(0, 0), this.getSequenceBlocks(0, 0));
    }

    @Test
    public void testSinglePosition() {
        this.testAggregation(this.getExpectedValue(0, 1), this.getSequenceBlocks(0, 1));
    }

    @Test
    public void testMultiplePositions() {
        this.testAggregation(this.getExpectedValue(0, 5), this.getSequenceBlocks(0, 5));
    }

    @Test
    public void testAllPositionsNull() {
        List parameterTypes = this.getFunction().getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return;
        }
        Block[] blocks = new Block[parameterTypes.size()];
        for (int i = 0; i < parameterTypes.size(); ++i) {
            blocks[i] = RunLengthEncodedBlock.create((Type)((Type)parameterTypes.get(0)), null, (int)10);
        }
        this.testAggregation(this.getExpectedValueIncludingNulls(0, 0, 10), blocks);
    }

    @Test
    public void testMixedNullAndNonNullPositions() {
        List parameterTypes = this.getFunction().getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return;
        }
        Block[] alternatingNullsBlocks = this.createAlternatingNullsBlock(parameterTypes, this.getSequenceBlocks(0, 10));
        this.testAggregation(this.getExpectedValueIncludingNulls(0, 10, 20), alternatingNullsBlocks);
    }

    @Test
    public void testNegativeOnlyValues() {
        this.testAggregation(this.getExpectedValue(-10, 5), this.getSequenceBlocks(-10, 5));
    }

    @Test
    public void testPositiveOnlyValues() {
        this.testAggregation(this.getExpectedValue(2, 4), this.getSequenceBlocks(2, 4));
    }

    public Block[] createAlternatingNullsBlock(List<Type> types, Block ... sequenceBlocks) {
        Block[] alternatingNullsBlocks = new Block[sequenceBlocks.length];
        for (int i = 0; i < sequenceBlocks.length; ++i) {
            int positionCount = sequenceBlocks[i].getPositionCount();
            Type type = types.get(i);
            BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                blockBuilder.appendNull();
                type.appendTo(sequenceBlocks[i], position, blockBuilder);
            }
            alternatingNullsBlocks[i] = blockBuilder.build();
        }
        return alternatingNullsBlocks;
    }

    protected void testAggregation(Object expectedValue, Block ... blocks) {
        AggregationTestUtils.assertAggregation(this.getFunction(), expectedValue, blocks);
    }
}

