/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import java.util.List;
import org.testng.annotations.Test;

public class TestApproximatePercentileAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}));
    private static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}));
    private static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}));
    private static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}));
    private static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}));
    private static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}));
    private static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(double)"), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(double)")}));
    private static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(double)"), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(double)")}));
    private static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(bigint)"), new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(double)")}));
    private static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(bigint)"), new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), TypeSignature.parseTypeSignature((String)"array(double)")}));
    private static final InternalAggregationFunction FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, RealType.REAL.getTypeSignature(), (List)ImmutableList.of((Object)RealType.REAL.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature())));
    private static final InternalAggregationFunction FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, RealType.REAL.getTypeSignature(), (List)ImmutableList.of((Object)RealType.REAL.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature())));
    private static final InternalAggregationFunction FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, RealType.REAL.getTypeSignature(), (List)ImmutableList.of((Object)RealType.REAL.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature())));
    private static final InternalAggregationFunction FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, new ArrayType((Type)RealType.REAL).getTypeSignature(), (List)ImmutableList.of((Object)RealType.REAL.getTypeSignature(), (Object)new ArrayType((Type)DoubleType.DOUBLE).getTypeSignature())));
    private static final InternalAggregationFunction FLOAT_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("approx_percentile", FunctionKind.AGGREGATE, new ArrayType((Type)RealType.REAL).getTypeSignature(), (List)ImmutableList.of((Object)RealType.REAL.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature(), (Object)new ArrayType((Type)DoubleType.DOUBLE).getTypeSignature())));

    @Test
    public void testLongPartialStep() {
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_AGGREGATION, null, new Block[]{BlockAssertions.createLongsBlock(null, null), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)1L, new Block[]{BlockAssertions.createLongsBlock(null, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)3L, new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, 2L, null, 2L, 2L, null, 2L, 2L, null, 3L, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 21)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, null, new Block[]{BlockAssertions.createLongsBlock(null, null), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, null, new Block[]{BlockAssertions.createLongsBlock(null, null), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)1L, (Object)1L), new Block[]{BlockAssertions.createLongsBlock(null, 1L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.2, (Object)0.5, (Object)0.8), 4)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)2L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 3)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)1L, (Object)3L), new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, 2L, null, 2L, 2L, null, 2L, 2L, null, 3L, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.01, (Object)0.5), 21)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, null, new Block[]{BlockAssertions.createLongsBlock(null, null), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)1L, new Block[]{BlockAssertions.createLongsBlock(null, 1L), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(null, 1L, 2L, 3L), BlockAssertions.createLongsBlock(1L, 1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), BlockAssertions.createLongsBlock(1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)3L, new Block[]{BlockAssertions.createLongsBlock(1L, null, 2L, null, 2L, null, 2L, null, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L), BlockAssertions.createLongsBlock(1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY, (Object)9900L, new Block[]{BlockAssertions.createLongSequenceBlock(0, 10000), BlockAssertions.createLongRepeatBlock(1, 10000), TestApproximatePercentileAggregation.createRLEBlock(0.99, 10000), TestApproximatePercentileAggregation.createRLEBlock(0.001, 10000)});
        AggregationTestUtils.assertAggregation(LONG_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION, (Object)ImmutableList.of((Object)1L, (Object)2L), new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 3L), BlockAssertions.createLongsBlock(4L, 2L, 1L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.8), 3)});
    }

    @Test
    public void testFloatPartialStep() {
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)Float.valueOf(1.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f)), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRLEBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)Float.valueOf(1.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(-1.0f), Float.valueOf(1.0f)), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)Float.valueOf(-1.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(-2.0f), Float.valueOf(3.0f), Float.valueOf(-1.0f)), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)Float.valueOf(3.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(3.0f), Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), TestApproximatePercentileAggregation.createRLEBlock(0.5, 21)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f)), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f)), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f)), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.2, (Object)0.5, (Object)0.8), 4)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f)), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 3)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(3.0f)), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(2.0f), Float.valueOf(2.0f), null, Float.valueOf(3.0f), Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.01, (Object)0.5), 21)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, null, new Block[]{BlockAssertions.createBlockOfReals(null, null), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)Float.valueOf(1.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f)), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createLongsBlock(1L, 1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)Float.valueOf(2.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createLongsBlock(1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)Float.valueOf(3.0f), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), null, Float.valueOf(2.0f), null, Float.valueOf(2.0f), null, Float.valueOf(2.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), null, Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)), BlockAssertions.createLongsBlock(1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY, (Object)Float.valueOf(9900.0f), new Block[]{BlockAssertions.createSequenceBlockOfReal(0, 10000), BlockAssertions.createLongRepeatBlock(1, 10000), TestApproximatePercentileAggregation.createRLEBlock(0.99, 10000), TestApproximatePercentileAggregation.createRLEBlock(0.001, 10000)});
        AggregationTestUtils.assertAggregation(FLOAT_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION, (Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)), new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createLongsBlock(4L, 2L, 1L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.8), 3)});
    }

    @Test
    public void testDoublePartialStep() {
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)1.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRLEBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, (Object)3.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 3.0, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), TestApproximatePercentileAggregation.createRLEBlock(0.5, 21)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)1.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.5), 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.2, (Object)0.5, (Object)0.8), 4)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.99), 3)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION, (Object)ImmutableList.of((Object)1.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 2.0, 2.0, null, 3.0, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.01, (Object)0.5), 21)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)1.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0), BlockAssertions.createLongsBlock(1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 2)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, 2.0, 3.0), BlockAssertions.createLongsBlock(1L, 1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 4)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createLongsBlock(1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 3)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, (Object)3.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, null, 2.0, null, 2.0, null, 2.0, null, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0), BlockAssertions.createLongsBlock(1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), TestApproximatePercentileAggregation.createRLEBlock(0.5, 17)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY, (Object)9900.0, new Block[]{BlockAssertions.createDoubleSequenceBlock(0, 10000), BlockAssertions.createLongRepeatBlock(1, 10000), TestApproximatePercentileAggregation.createRLEBlock(0.99, 10000), TestApproximatePercentileAggregation.createRLEBlock(0.001, 10000)});
        AggregationTestUtils.assertAggregation(DOUBLE_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION, (Object)ImmutableList.of((Object)1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createLongsBlock(4L, 2L, 1L), TestApproximatePercentileAggregation.createRLEBlock((Iterable<Double>)ImmutableList.of((Object)0.5, (Object)0.8), 3)});
    }

    private static RunLengthEncodedBlock createRLEBlock(double percentile, int positionCount) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        DoubleType.DOUBLE.writeDouble(blockBuilder, percentile);
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }

    private static RunLengthEncodedBlock createRLEBlock(Iterable<Double> percentiles, int positionCount) {
        BlockBuilder rleBlockBuilder = new ArrayType((Type)DoubleType.DOUBLE).createBlockBuilder(null, 1);
        BlockBuilder arrayBlockBuilder = rleBlockBuilder.beginBlockEntry();
        for (double percentile : percentiles) {
            DoubleType.DOUBLE.writeDouble(arrayBlockBuilder, percentile);
        }
        rleBlockBuilder.closeEntry();
        return new RunLengthEncodedBlock(rleBlockBuilder.build(), positionCount);
    }
}

