/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.util.StructuralTestUtil;
import java.util.List;

public class TestArrayMinAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public List<Long> getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return ImmutableList.of((Object)start);
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"array(bigint)");
    }
}

