/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import java.util.List;
import java.util.stream.LongStream;
import org.testng.annotations.Test;

public class TestBitwiseOrAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return LongStream.range(start, start + length).reduce(start, (x, y) -> x | y);
    }

    @Override
    protected String getFunctionName() {
        return "bitwise_or_agg";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"bigint");
    }

    @Test
    public void testNulls() {
        this.testAggregation(1L, BlockAssertions.createLongsBlock(1L, null));
        this.testAggregation(1L, BlockAssertions.createLongsBlock(null, 1L));
    }
}

