/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BooleanType;
import java.util.List;

public class TestBooleanAndAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, i % 2 == 0);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Boolean getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return length > 1 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected String getFunctionName() {
        return "bool_and";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"boolean");
    }
}

