/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.operator.aggregation.NullablePosition;
import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import java.util.List;
import org.testng.annotations.BeforeClass;

public class TestCountNullAggregation
extends AbstractTestAggregationFunction {
    @BeforeClass
    public void setup() {
        this.functionRegistry.addFunctions(new FunctionListBuilder().aggregates(CountNull.class).getFunctions());
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return 0L;
    }

    @Override
    public Object getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        return (long)lengthIncludingNulls - (long)length;
    }

    @Override
    protected String getFunctionName() {
        return "count_null";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"bigint");
    }

    @AggregationFunction(value="count_null")
    public static final class CountNull {
        private CountNull() {
        }

        @InputFunction
        public static void input(@AggregationState NullableLongState state, @BlockPosition @NullablePosition @SqlType(value="bigint") Block block, @BlockIndex int position) {
            if (block.isNull(position)) {
                state.setLong(state.getLong() + 1L);
            }
            state.setNull(false);
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState scratchState) {
            state.setLong(state.getLong() + scratchState.getLong());
            state.setNull(state.isNull() && scratchState.isNull());
        }

        @OutputFunction(value="bigint")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
            NullableLongState.write((Type)BigintType.BIGINT, (NullableLongState)state, (BlockBuilder)out);
        }
    }
}

