/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.SqlDate;
import java.util.List;

public class TestDateMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DateType.DATE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DateType.DATE.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlDate getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return new SqlDate(start + length - 1);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"date");
    }
}

