/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.spi.block.Block;
import java.util.List;
import org.apache.commons.math3.stat.correlation.Covariance;

public class TestDoubleCovariancePopAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createDoubleSequenceBlock(start + 5, start + 5 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "covar_pop";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double", (Object)"double");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 0) {
            return null;
        }
        if (length == 1) {
            return 0.0;
        }
        Covariance covariance = new Covariance();
        return covariance.covariance(AggregationTestUtils.constructDoublePrimitiveArray(start + 5, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length), false);
    }
}

