/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.aggregation.Accumulator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.type.TypeRegistry;
import io.prestosql.util.StructuralTestUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleHistogramAggregation {
    private final AccumulatorFactory factory;
    private final Page input;

    public TestDoubleHistogramAggregation() {
        TypeRegistry typeRegistry = new TypeRegistry();
        FunctionRegistry functionRegistry = new FunctionRegistry((TypeManager)typeRegistry, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeRegistry, new BlockEncoding[0]), new FeaturesConfig());
        InternalAggregationFunction function = functionRegistry.getAggregateFunctionImplementation(new Signature("numeric_histogram", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"map(double,double)"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint"), TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"double")}));
        this.factory = function.bind((List)ImmutableList.of((Object)0, (Object)1, (Object)2), Optional.empty());
        this.input = TestDoubleHistogramAggregation.makeInput(10);
    }

    @Test
    public void test() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block expected = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Block partialBlock = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(partialBlock);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Assert.assertEquals(TestDoubleHistogramAggregation.extractSingleValue(actual), TestDoubleHistogramAggregation.extractSingleValue(expected));
    }

    @Test
    public void testMerge() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block singleStepResult = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Block intermediate = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(intermediate);
        finalStep.addIntermediate(intermediate);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Map expected = Maps.transformValues(TestDoubleHistogramAggregation.extractSingleValue(singleStepResult), value -> value * 2.0);
        Assert.assertEquals(TestDoubleHistogramAggregation.extractSingleValue(actual), (Map)expected);
    }

    @Test
    public void testNull() {
        Accumulator accumulator = this.factory.createAccumulator();
        Block result = AggregationTestUtils.getFinalBlock(accumulator);
        Assert.assertTrue((result.getPositionCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isNull(0));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testBadNumberOfBuckets() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(TestDoubleHistogramAggregation.makeInput(0));
        AggregationTestUtils.getFinalBlock(singleStep);
    }

    private static Map<Double, Double> extractSingleValue(Block block) {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
        return (Map)mapType.getObjectValue(null, block, 0);
    }

    private static Page makeInput(int numberOfBuckets) {
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        for (int i = 0; i < 100; ++i) {
            builder.declarePosition();
            BigintType.BIGINT.writeLong(builder.getBlockBuilder(0), (long)numberOfBuckets);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(1), (double)i);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(2), 1.0);
        }
        return builder.build();
    }
}

