/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DoubleType;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class TestDoubleStdDevAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length < 2) {
            return null;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = start + i;
        }
        StandardDeviation stdDev = new StandardDeviation();
        return stdDev.evaluate(values);
    }

    @Override
    protected String getFunctionName() {
        return "stddev";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double");
    }
}

