/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.GroupedAccumulator;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.groupby.AggregationTestInput;
import io.prestosql.operator.aggregation.groupby.AggregationTestInputBuilder;
import io.prestosql.operator.aggregation.groupby.AggregationTestOutput;
import io.prestosql.operator.aggregation.groupby.GroupByAggregationTestUtils;
import io.prestosql.operator.aggregation.histogram.HistogramGroupImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.util.DateTimeZoneIndex;
import io.prestosql.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.internal.collections.Ints;

public class TestHistogram {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"UTC");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);

    @Test
    public void testSimpleHistograms() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"varchar"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L), BlockAssertions.createStringsBlock("a", "b", "c"));
        mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        aggregationFunction = this.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("histogram", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)100L, (Object)1L, (Object)200L, (Object)1L, (Object)300L, (Object)1L), BlockAssertions.createLongsBlock(100L, 200L, 300L));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT);
        aggregationFunction = this.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("histogram", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double")}));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)0.1, (Object)1L, (Object)0.3, (Object)1L, (Object)0.2, (Object)1L), BlockAssertions.createDoublesBlock(0.1, 0.3, 0.2));
        mapType = StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT);
        aggregationFunction = this.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("histogram", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)true, (Object)1L, (Object)false, (Object)1L), BlockAssertions.createBooleansBlock(true, false));
    }

    @Test
    public void testSharedGroupBy() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"varchar"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L), BlockAssertions.createStringsBlock("a", "b", "c"));
        mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"bigint"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)100L, (Object)1L, (Object)200L, (Object)1L, (Object)300L, (Object)1L), BlockAssertions.createLongsBlock(100L, 200L, 300L));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT);
        aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"double"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)0.1, (Object)1L, (Object)0.3, (Object)1L, (Object)0.2, (Object)1L), BlockAssertions.createDoublesBlock(0.1, 0.3, 0.2));
        mapType = StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT);
        aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"boolean"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)true, (Object)1L, (Object)false, (Object)1L), BlockAssertions.createBooleansBlock(true, false));
    }

    @Test
    public void testDuplicateKeysValues() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"varchar"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)2L, (Object)"b", (Object)1L), BlockAssertions.createStringsBlock("a", "b", "a"));
        mapType = StructuralTestUtil.mapType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Type)BigintType.BIGINT);
        aggregationFunction = this.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("histogram", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"timestamp with time zone")}));
        long timestampWithTimeZone1 = DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), (TimeZoneKey)TIME_ZONE_KEY);
        long timestampWithTimeZone2 = DateTimeEncoding.packDateTimeWithZone((long)new DateTime(2015, 1, 1, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), (TimeZoneKey)TIME_ZONE_KEY);
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)new SqlTimestampWithTimeZone(timestampWithTimeZone1), (Object)2L, (Object)new SqlTimestampWithTimeZone(timestampWithTimeZone2), (Object)1L), BlockAssertions.createLongsBlock(timestampWithTimeZone1, timestampWithTimeZone1, timestampWithTimeZone2));
    }

    @Test
    public void testWithNulls() {
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"bigint"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)1L, (Object)1L, (Object)2L, (Object)1L), BlockAssertions.createLongsBlock(2L, null, 1L));
        mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        aggregationFunction = this.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("histogram", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        AggregationTestUtils.assertAggregation(aggregationFunction, null, BlockAssertions.createLongsBlock(new Long[]{null}));
    }

    @Test
    public void testArrayHistograms() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        MapType mapType = StructuralTestUtil.mapType((Type)arrayType, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), arrayType.getTypeSignature());
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)1L, (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"), (Object)1L, (Object)ImmutableList.of((Object)"c", (Object)"b", (Object)"a"), (Object)1L), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"), (Object)ImmutableList.of((Object)"c", (Object)"b", (Object)"a"))));
    }

    @Test
    public void testMapHistograms() {
        MapType innerMapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        MapType mapType = StructuralTestUtil.mapType((Type)innerMapType, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), innerMapType.getTypeSignature());
        BlockBuilder builder = innerMapType.createBlockBuilder(null, 3);
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"a", (Object)"b")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"c", (Object)"d")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)1L, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)1L, (Object)ImmutableMap.of((Object)"e", (Object)"f"), (Object)1L), builder.build());
    }

    @Test
    public void testRowHistograms() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        MapType mapType = StructuralTestUtil.mapType((Type)innerRowType, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), innerRowType.getTypeSignature());
        BlockBuilder builder = innerRowType.createBlockBuilder(null, 3);
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 1L, 1.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2L, 2.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 3L, 3.0));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)1L, (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)1L, (Object)ImmutableList.of((Object)3L, (Object)3.0), (Object)1L), builder.build());
    }

    @Test
    public void testLargerHistograms() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        InternalAggregationFunction aggregationFunction = this.getAggregation(mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"varchar"));
        AggregationTestUtils.assertAggregation(aggregationFunction, (Object)ImmutableMap.of((Object)"a", (Object)25L, (Object)"b", (Object)10L, (Object)"c", (Object)12L, (Object)"d", (Object)1L, (Object)"e", (Object)2L), BlockAssertions.createStringsBlock("a", "b", "c", "d", "e", "e", "c", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "a", "a", "a", "b", "a", "c", "c", "b", "a", "c", "c", "b", "a", "c", "c", "b", "a", "c", "c", "b", "a", "c", "c"));
    }

    @Test
    public void testEmptyHistogramOutputsNull() {
        InternalAggregationFunction function = this.getInternalDefaultVarCharAggregationn();
        GroupedAccumulator groupedAccumulator = function.bind(Ints.asList((int[])new int[0]), Optional.empty()).createGroupedAccumulator();
        BlockBuilder blockBuilder = groupedAccumulator.getFinalType().createBlockBuilder(null, 1000);
        groupedAccumulator.evaluateFinal(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.isNull(0));
    }

    @Test
    public void testSharedGroupByWithOverlappingValuesRunner() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testSharedGroupByWithOverlappingValuesRunner(classicFunction);
        this.testSharedGroupByWithOverlappingValuesRunner(singleInstanceFunction);
    }

    @Test
    public void testSharedGroupByWithDistinctValuesPerGroup() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testSharedGroupByWithDistinctValuesPerGroupRunner(classicFunction);
        this.testSharedGroupByWithDistinctValuesPerGroupRunner(singleInstanceFunction);
    }

    @Test
    public void testSharedGroupByWithOverlappingValuesPerGroup() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testSharedGroupByWithOverlappingValuesPerGroupRunner(classicFunction);
        this.testSharedGroupByWithOverlappingValuesPerGroupRunner(singleInstanceFunction);
    }

    @Test
    public void testSharedGroupByWithManyGroups() {
        InternalAggregationFunction classicFunction = this.getInternalDefaultVarCharAggregationn();
        InternalAggregationFunction singleInstanceFunction = this.getInternalDefaultVarCharAggregationn();
        this.testManyValuesInducingRehash(classicFunction);
        this.testManyValuesInducingRehash(singleInstanceFunction);
    }

    private void testManyValuesInducingRehash(InternalAggregationFunction aggregationFunction) {
        double distinctFraction = 0.1f;
        int numGroups = 50000;
        int itemCount = 30;
        Random random = new Random();
        GroupedAccumulator groupedAccumulator = this.createGroupedAccumulator(aggregationFunction);
        for (int j = 0; j < numGroups; ++j) {
            HashMap<String, Long> expectedValues = new HashMap<String, Long>();
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < itemCount; ++i) {
                boolean distinctValue;
                String str = String.valueOf(i % 10);
                String item = IntStream.range(0, itemCount).mapToObj(x -> str).collect(Collectors.joining());
                boolean bl = distinctValue = random.nextDouble() < distinctFraction;
                if (distinctValue) {
                    item = j + "-" + item;
                    valueList.add(item);
                } else {
                    valueList.add(item);
                }
                expectedValues.compute(item, (k, v) -> {
                    long l;
                    if (v == null) {
                        l = 1L;
                    } else {
                        v = v + 1L;
                        l = v;
                    }
                    return l;
                });
            }
            Block block = BlockAssertions.createStringsBlock(valueList);
            AggregationTestInputBuilder testInputBuilder = new AggregationTestInputBuilder(new Block[]{block}, aggregationFunction);
            AggregationTestInput test1 = testInputBuilder.build();
            test1.runPagesOnAccumulatorWithAssertion(j, groupedAccumulator, new AggregationTestOutput(expectedValues));
        }
    }

    private GroupedAccumulator createGroupedAccumulator(InternalAggregationFunction function) {
        int[] args = GroupByAggregationTestUtils.createArgs(function);
        return function.bind(Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator();
    }

    private void testSharedGroupByWithOverlappingValuesPerGroupRunner(InternalAggregationFunction aggregationFunction) {
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c");
        Block block2 = BlockAssertions.createStringsBlock("b", "c", "d");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L));
        AggregationTestInputBuilder testBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, aggregationFunction);
        AggregationTestInput test1 = testBuilder1.build();
        GroupedAccumulator groupedAccumulator = test1.createGroupedAccumulator();
        test1.runPagesOnAccumulatorWithAssertion(0L, groupedAccumulator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableMap.of((Object)"b", (Object)1L, (Object)"c", (Object)1L, (Object)"d", (Object)1L));
        AggregationTestInputBuilder testbuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, aggregationFunction);
        AggregationTestInput test2 = testbuilder2.build();
        test2.runPagesOnAccumulatorWithAssertion(255L, groupedAccumulator, aggregationTestOutput2);
    }

    private void testSharedGroupByWithDistinctValuesPerGroupRunner(InternalAggregationFunction aggregationFunction) {
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c");
        Block block2 = BlockAssertions.createStringsBlock("d", "e", "f");
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)1L, (Object)"c", (Object)1L));
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, aggregationFunction);
        AggregationTestInput test1 = testInputBuilder1.build();
        GroupedAccumulator groupedAccumulator = test1.createGroupedAccumulator();
        test1.runPagesOnAccumulatorWithAssertion(0L, groupedAccumulator, aggregationTestOutput1);
        AggregationTestOutput aggregationTestOutput2 = new AggregationTestOutput(ImmutableMap.of((Object)"d", (Object)1L, (Object)"e", (Object)1L, (Object)"f", (Object)1L));
        AggregationTestInputBuilder testBuilder2 = new AggregationTestInputBuilder(new Block[]{block2}, aggregationFunction);
        AggregationTestInput test2 = testBuilder2.build();
        test2.runPagesOnAccumulatorWithAssertion(255L, groupedAccumulator, aggregationTestOutput2);
    }

    private void testSharedGroupByWithOverlappingValuesRunner(InternalAggregationFunction aggregationFunction) {
        Block block1 = BlockAssertions.createStringsBlock("a", "b", "c", "d", "a1", "b2", "c3", "d4", "a", "b2", "c", "d4", "a3", "b3", "c3", "b2");
        AggregationTestInputBuilder testInputBuilder1 = new AggregationTestInputBuilder(new Block[]{block1}, aggregationFunction);
        AggregationTestOutput aggregationTestOutput1 = new AggregationTestOutput(ImmutableMap.builder().put((Object)"a", (Object)2L).put((Object)"b", (Object)1L).put((Object)"c", (Object)2L).put((Object)"d", (Object)1L).put((Object)"a1", (Object)1L).put((Object)"b2", (Object)3L).put((Object)"c3", (Object)2L).put((Object)"d4", (Object)2L).put((Object)"a3", (Object)1L).put((Object)"b3", (Object)1L).build());
        AggregationTestInput test1 = testInputBuilder1.build();
        test1.runPagesOnAccumulatorWithAssertion(0L, test1.createGroupedAccumulator(), aggregationTestOutput1);
    }

    private InternalAggregationFunction getInternalDefaultVarCharAggregationn() {
        TypeSignature returnType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT).getTypeSignature();
        TypeSignature argumentType = TypeSignature.parseTypeSignature((String)"varchar");
        return this.getAggregation(returnType, argumentType);
    }

    private InternalAggregationFunction getAggregation(TypeSignature returnType, TypeSignature ... arguments) {
        MetadataManager metadata = this.getMetadata(HistogramGroupImplementation.NEW);
        Signature signature = new Signature("histogram", FunctionKind.AGGREGATE, returnType, Arrays.asList(arguments));
        return metadata.getFunctionRegistry().getAggregateFunctionImplementation(signature);
    }

    public MetadataManager getMetadata() {
        return this.getMetadata(HistogramGroupImplementation.NEW);
    }

    public MetadataManager getMetadata(HistogramGroupImplementation groupMode) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager((FeaturesConfig)new FeaturesConfig().setHistogramGroupImplementation(groupMode));
        return metadata;
    }
}

