/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.type.IntervalDayTimeType;
import io.prestosql.type.SqlIntervalDayTime;
import java.util.List;

public class TestIntervalDayToSecondSumAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalDayTimeType.INTERVAL_DAY_TIME.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, (long)(i * 1000));
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlIntervalDayTime getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        long sum = 0L;
        for (int i = start; i < start + length; ++i) {
            sum += (long)(i * 1000);
        }
        return new SqlIntervalDayTime(sum);
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"interval day to second");
    }
}

