/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.SqlDecimal;
import java.math.BigDecimal;
import java.util.List;

public class TestLongDecimalMaxAggregation
extends AbstractTestAggregationFunction {
    public static final DecimalType LONG_DECIMAL = DecimalType.createDecimalType((int)30, (int)5);

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = LONG_DECIMAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL, (BlockBuilder)blockBuilder, (BigDecimal)BigDecimal.valueOf(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return SqlDecimal.of((long)(start + length - 1), (int)30, (int)5);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)LONG_DECIMAL.getTypeSignature().toString());
    }
}

