/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongMaxNAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createLongSequenceBlock(start, start + length), BlockAssertions.createLongRepeatBlock(2, length)};
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"bigint", (Object)"bigint");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return ImmutableList.of((Object)start);
        }
        return ImmutableList.of((Object)((long)start + (long)length - 1L), (Object)((long)start + (long)length - 2L));
    }

    @Test
    public void testMoreCornerCases() {
        this.testCustomAggregation(new Long[]{1L, 2L, null, 3L}, 5);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 0);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, -1);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 10001);
    }

    private void testInvalidAggregation(Long[] x, int n) {
        try {
            this.testAggregation(new long[0], BlockAssertions.createLongsBlock(x), BlockAssertions.createLongRepeatBlock(n, x.length));
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getErrorCode().getName(), (String)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.name());
        }
    }

    private void testCustomAggregation(Long[] values, int n) {
        PriorityQueue heap = new PriorityQueue(n);
        Arrays.stream(values).filter(x -> x != null).forEach(heap::add);
        Long[] expected = new Long[heap.size()];
        for (int i = heap.size() - 1; i >= 0; --i) {
            expected[i] = (Long)heap.remove();
        }
        this.testAggregation(Arrays.asList(expected), BlockAssertions.createLongsBlock(values), BlockAssertions.createLongRepeatBlock(n, values.length));
    }
}

