/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.StructuralTestUtil;
import java.util.LinkedHashMap;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapAggAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testDuplicateKeysValues() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"varchar")}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)"a"), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), BlockAssertions.createStringsBlock("a", "b", "c"));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)IntegerType.INTEGER);
        aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"integer")}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)99, (Object)2.0, (Object)99, (Object)3.0, (Object)99), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, (Iterable<Long>)ImmutableList.of((Object)99L, (Object)99L, (Object)99L)));
    }

    @Test
    public void testSimpleMaps() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"varchar")}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)"a", (Object)2.0, (Object)"b", (Object)3.0, (Object)"c"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringsBlock("a", "b", "c"));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)IntegerType.INTEGER);
        aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"integer")}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)3, (Object)2.0, (Object)2, (Object)3.0, (Object)1), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, (Iterable<Long>)ImmutableList.of((Object)3L, (Object)2L, (Object)1L)));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN);
        aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"boolean")}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)true, (Object)2.0, (Object)false, (Object)3.0, (Object)false), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createBooleansBlock(true, false, false));
    }

    @Test
    public void testNull() {
        InternalAggregationFunction doubleDouble = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE).getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"double")}));
        AggregationTestUtils.assertAggregation(doubleDouble, (Object)ImmutableMap.of((Object)1.0, (Object)2.0), BlockAssertions.createDoublesBlock(1.0, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0));
        AggregationTestUtils.assertAggregation(doubleDouble, null, BlockAssertions.createDoublesBlock(null, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0));
        LinkedHashMap<Double, Object> expected = new LinkedHashMap<Double, Object>();
        expected.put(1.0, null);
        expected.put(2.0, null);
        expected.put(3.0, null);
        AggregationTestUtils.assertAggregation(doubleDouble, expected, BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(null, null, null));
    }

    @Test
    public void testDoubleArrayMap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)arrayType);
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), arrayType.getTypeSignature()}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f")), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))));
    }

    @Test
    public void testDoubleMapMap() {
        MapType innerMapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)innerMapType);
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), innerMapType.getTypeSignature()}));
        BlockBuilder builder = innerMapType.createBlockBuilder(null, 3);
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"a", (Object)"b")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"c", (Object)"d")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), builder.build());
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)innerRowType);
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), innerRowType.getTypeSignature()}));
        BlockBuilder builder = innerRowType.createBlockBuilder(null, 3);
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 1L, 1.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 2L, 2.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 3L, 3.0));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1, (Object)1.0), (Object)2.0, (Object)ImmutableList.of((Object)2, (Object)2.0), (Object)3.0, (Object)ImmutableList.of((Object)3, (Object)3.0)), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), builder.build());
    }

    @Test
    public void testArrayDoubleMap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        MapType mapType = StructuralTestUtil.mapType((Type)arrayType, (Type)DoubleType.DOUBLE);
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("map_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"double")}));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0));
    }
}

