/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.primitives.Ints;
import io.prestosql.RowPageBuilder;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.GroupedAccumulator;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.groupby.AggregationTestInput;
import io.prestosql.operator.aggregation.groupby.AggregationTestInputBuilder;
import io.prestosql.operator.aggregation.groupby.AggregationTestOutput;
import io.prestosql.operator.aggregation.groupby.GroupByAggregationTestUtils;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMultimapAggAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testSingleValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L));
    }

    @Test
    public void testMultiValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)2.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    @Test
    public void testOrderValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)1L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)3L, (Object)2L, (Object)1L));
    }

    @Test
    public void testDuplicateValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b", (Object)"c"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L, (Object)1L, (Object)1L));
    }

    @Test
    public void testNullMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of(), (Type)VarcharType.VARCHAR, ImmutableList.of());
    }

    @Test
    public void testDoubleMapMultimap() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)1L), (Object)ImmutableMap.of((Object)"b", (Object)2L, (Object)"c", (Object)3L, (Object)"d", (Object)4L), (Object)ImmutableMap.of((Object)"a", (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)mapType, expectedValues);
    }

    @Test
    public void testDoubleArrayMultimap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)arrayType, expectedValues);
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Type)innerRowType, ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)ImmutableList.of((Object)3L, (Object)3.0)));
    }

    @Test
    public void testMultiplePages() {
        InternalAggregationFunction aggFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = this.getGroupedAccumulator(aggFunction);
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, 0, (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)3L));
    }

    @Test
    public void testMultiplePagesAndGroups() {
        InternalAggregationFunction aggFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = this.getGroupedAccumulator(aggFunction);
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, 0, (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, 300, (Type)BigintType.BIGINT, ImmutableList.of((Object)7L, (Object)7L), (Type)BigintType.BIGINT, ImmutableList.of((Object)8L, (Object)9L));
    }

    @Test
    public void testManyValues() {
        InternalAggregationFunction aggFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = this.getGroupedAccumulator(aggFunction);
        int numGroups = 30000;
        int numKeys = 10;
        int numValueArraySize = 2;
        Random random = new Random();
        for (int group = 0; group < numGroups; ++group) {
            ImmutableList.Builder keyBuilder = ImmutableList.builder();
            ImmutableList.Builder valueBuilder = ImmutableList.builder();
            for (int i = 0; i < numKeys; ++i) {
                long key = random.nextLong();
                for (int j = 0; j < numValueArraySize; ++j) {
                    long value = random.nextLong();
                    keyBuilder.add((Object)key);
                    valueBuilder.add((Object)value);
                }
            }
            TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAccumulator, group, (Type)BigintType.BIGINT, keyBuilder.build(), (Type)BigintType.BIGINT, valueBuilder.build());
        }
    }

    @Test
    public void testEmptyStateOutputIsNull() {
        InternalAggregationFunction aggregationFunction = TestMultimapAggAggregation.getInternalAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAccumulator groupedAccumulator = aggregationFunction.bind(Ints.asList((int[])new int[0]), Optional.empty()).createGroupedAccumulator();
        BlockBuilder blockBuilder = groupedAccumulator.getFinalType().createBlockBuilder(null, 1);
        groupedAccumulator.evaluateFinal(0, blockBuilder);
        Assert.assertTrue((boolean)blockBuilder.isNull(0));
    }

    private static <K, V> void testMultimapAgg(Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        Preconditions.checkState((expectedKeys.size() == expectedValues.size() ? 1 : 0) != 0, (Object)"expectedKeys and expectedValues should have equal size");
        InternalAggregationFunction aggFunc = TestMultimapAggAggregation.getInternalAggregationFunction(keyType, valueType);
        TestMultimapAggAggregation.testMultimapAgg(aggFunc, keyType, expectedKeys, valueType, expectedValues);
    }

    private static InternalAggregationFunction getInternalAggregationFunction(Type keyType, Type valueType) {
        MapType mapType = StructuralTestUtil.mapType(keyType, (Type)new ArrayType(valueType));
        Signature signature = new Signature("multimap_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{keyType.getTypeSignature(), valueType.getTypeSignature()});
        return metadata.getFunctionRegistry().getAggregateFunctionImplementation(signature);
    }

    private static <K, V> void testMultimapAgg(InternalAggregationFunction aggFunc, Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        HashMap map = new HashMap();
        for (int i = 0; i < expectedKeys.size(); ++i) {
            if (!map.containsKey(expectedKeys.get(i))) {
                map.put(expectedKeys.get(i), new ArrayList());
            }
            ((List)map.get(expectedKeys.get(i))).add(expectedValues.get(i));
        }
        RowPageBuilder builder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        for (int i = 0; i < expectedKeys.size(); ++i) {
            builder.row(expectedKeys.get(i), expectedValues.get(i));
        }
        AggregationTestUtils.assertAggregation(aggFunc, map.isEmpty() ? null : map, builder.build());
    }

    private static <K, V> void testMultimapAggWithGroupBy(InternalAggregationFunction aggregationFunction, GroupedAccumulator groupedAccumulator, int groupId, Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        RowPageBuilder pageBuilder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        ImmutableMultimap.Builder outputBuilder = ImmutableMultimap.builder();
        for (int i = 0; i < expectedValues.size(); ++i) {
            pageBuilder.row(expectedKeys.get(i), expectedValues.get(i));
            outputBuilder.put(expectedKeys.get(i), expectedValues.get(i));
        }
        Page page = pageBuilder.build();
        AggregationTestInput input = new AggregationTestInputBuilder(new Block[]{page.getBlock(0), page.getBlock(1)}, aggregationFunction).build();
        AggregationTestOutput testOutput = new AggregationTestOutput(outputBuilder.build().asMap());
        input.runPagesOnAccumulatorWithAssertion(groupId, groupedAccumulator, testOutput);
    }

    private GroupedAccumulator getGroupedAccumulator(InternalAggregationFunction aggFunction) {
        return aggFunction.bind(Ints.asList((int[])GroupByAggregationTestUtils.createArgs(aggFunction)), Optional.empty()).createGroupedAccumulator();
    }
}

