/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.SqlDecimal;
import java.util.List;

public class TestShortDecimalMaxAggregation
extends AbstractTestAggregationFunction {
    public static final DecimalType SHORT_DECIMAL = DecimalType.createDecimalType((int)10, (int)5);

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = SHORT_DECIMAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            SHORT_DECIMAL.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return SqlDecimal.of((long)(start + length - 1), (int)10, (int)5);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)SHORT_DECIMAL.getTypeSignature().toString());
    }
}

