/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.histogram.SingleTypedHistogram;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.util.StructuralTestUtil;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedHistogram {
    @Test
    public void testMassive() {
        BlockBuilder inputBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 5000);
        SingleTypedHistogram typedHistogram = new SingleTypedHistogram((Type)BigintType.BIGINT, 1000);
        IntStream.range(1, 2000).flatMap(i -> IntStream.iterate(i, IntUnaryOperator.identity()).limit(i)).forEach(j -> BigintType.BIGINT.writeLong(inputBlockBuilder, (long)j));
        Block inputBlock = inputBlockBuilder.build();
        for (int i2 = 0; i2 < inputBlock.getPositionCount(); ++i2) {
            typedHistogram.add(i2, inputBlock, 1L);
        }
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        BlockBuilder out = mapType.createBlockBuilder(null, 1);
        typedHistogram.serialize(out);
        Block outputBlock = mapType.getObject((Block)out, 0);
        for (int i3 = 0; i3 < outputBlock.getPositionCount(); i3 += 2) {
            Assert.assertEquals((long)BigintType.BIGINT.getLong(outputBlock, i3 + 1), (long)BigintType.BIGINT.getLong(outputBlock, i3));
        }
    }
}

