/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.prestosql.SequencePageBuilder;
import io.prestosql.execution.buffer.PageSplitterUtil;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.project.MergingPageOutput;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMergingPageOutput {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE);

    @Test
    public void testMinPageSizeThreshold() {
        Page page = SequencePageBuilder.createSequencePage(TYPES, 10);
        MergingPageOutput output = new MergingPageOutput(TYPES, page.getSizeInBytes(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertTrue((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        output.addInput(TestMergingPageOutput.createPagesIterator(page));
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertSame((Object)output.getOutput(), (Object)page);
    }

    @Test
    public void testMinRowCountThreshold() {
        Page page = SequencePageBuilder.createSequencePage(TYPES, 10);
        MergingPageOutput output = new MergingPageOutput(TYPES, 0x100000L, page.getPositionCount(), Integer.MAX_VALUE);
        Assert.assertTrue((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        output.addInput(TestMergingPageOutput.createPagesIterator(page));
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertSame((Object)output.getOutput(), (Object)page);
    }

    @Test
    public void testBufferSmallPages() {
        int singlePageRowCount = 10;
        Page page = SequencePageBuilder.createSequencePage(TYPES, singlePageRowCount * 2);
        List splits = PageSplitterUtil.splitPage((Page)page, (long)(page.getSizeInBytes() / 2L));
        MergingPageOutput output = new MergingPageOutput(TYPES, page.getSizeInBytes() + 1L, page.getPositionCount() + 1, Integer.MAX_VALUE);
        Assert.assertTrue((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        output.addInput(TestMergingPageOutput.createPagesIterator((Page)splits.get(0)));
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        Assert.assertTrue((boolean)output.needsInput());
        output.addInput(TestMergingPageOutput.createPagesIterator((Page)splits.get(1)));
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        output.finish();
        Assert.assertFalse((boolean)output.needsInput());
        PageAssertions.assertPageEquals(TYPES, output.getOutput(), page);
    }

    @Test
    public void testFlushOnBigPage() {
        Page smallPage = SequencePageBuilder.createSequencePage(TYPES, 10);
        Page bigPage = SequencePageBuilder.createSequencePage(TYPES, 100);
        MergingPageOutput output = new MergingPageOutput(TYPES, bigPage.getSizeInBytes(), bigPage.getPositionCount(), Integer.MAX_VALUE);
        Assert.assertTrue((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        output.addInput(TestMergingPageOutput.createPagesIterator(smallPage));
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        Assert.assertTrue((boolean)output.needsInput());
        output.addInput(TestMergingPageOutput.createPagesIterator(bigPage));
        Assert.assertFalse((boolean)output.needsInput());
        PageAssertions.assertPageEquals(TYPES, output.getOutput(), smallPage);
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertSame((Object)output.getOutput(), (Object)bigPage);
    }

    @Test
    public void testFlushOnFullPage() {
        int singlePageRowCount = 10;
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        Page page = SequencePageBuilder.createSequencePage((List<? extends Type>)types, singlePageRowCount * 2);
        List splits = PageSplitterUtil.splitPage((Page)page, (long)(page.getSizeInBytes() / 2L));
        MergingPageOutput output = new MergingPageOutput((Iterable)types, page.getSizeInBytes() / 2L + 1L, page.getPositionCount() / 2 + 1, Math.toIntExact(page.getSizeInBytes()));
        Assert.assertTrue((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        output.addInput(TestMergingPageOutput.createPagesIterator((Page)splits.get(0)));
        Assert.assertFalse((boolean)output.needsInput());
        Assert.assertNull((Object)output.getOutput());
        Assert.assertTrue((boolean)output.needsInput());
        output.addInput(TestMergingPageOutput.createPagesIterator((Page)splits.get(1)));
        Assert.assertFalse((boolean)output.needsInput());
        PageAssertions.assertPageEquals((List<? extends Type>)types, output.getOutput(), page);
        output.addInput(TestMergingPageOutput.createPagesIterator((Page)splits.get(0), (Page)splits.get(1)));
        Assert.assertFalse((boolean)output.needsInput());
        PageAssertions.assertPageEquals((List<? extends Type>)types, output.getOutput(), page);
    }

    private static Iterator<Optional<Page>> createPagesIterator(Page ... pages) {
        return TestMergingPageOutput.createPagesIterator((List<Page>)ImmutableList.copyOf((Object[])pages));
    }

    private static Iterator<Optional<Page>> createPagesIterator(List<Page> pages) {
        return Iterators.transform(pages.iterator(), Optional::of);
    }
}

