/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.prestosql.block.BlockAssertions;
import io.prestosql.execution.executor.PrioritizedSplitRunner;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.CompletedWork;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.Work;
import io.prestosql.operator.project.InputChannels;
import io.prestosql.operator.project.InputPageProjection;
import io.prestosql.operator.project.PageFilter;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.VariableWidthBlock;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionProfiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestPageProcessor {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testProjectNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of(), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assert.assertEquals((int)outputPage.getChannelCount(), (int)0);
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)inputPage.getPositionCount());
    }

    @Test
    public void testFilterNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsRange((int)0, (int)50))), (List)ImmutableList.of());
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assert.assertEquals((int)outputPage.getChannelCount(), (int)0);
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)50);
    }

    @Test
    public void testPartialFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsRange((int)25, (int)50))), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(25, 75)}));
    }

    @Test
    public void testSelectAllFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testSelectNoneFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectNoneFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testProjectEmptyPage() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 0)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testSelectNoneFilterLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectNoneFilter()), (List)ImmutableList.of((Object)new InputPageProjection(1, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testProjectLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new LazyPagePageProjection()), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testBatchedOutput() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 20480)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assert.assertEquals((int)outputPages.size(), (int)3);
        for (int i = 0; i < outputPages.size(); ++i) {
            Page actualPage = ((Optional)outputPages.get(i)).orElse(null);
            int offset = i * 8192;
            Page expectedPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(offset, offset + Math.min(inputPage.getPositionCount() - offset, 8192))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actualPage, expectedPage);
        }
    }

    @Test
    public void testAdaptiveBatchSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)VarcharType.VARCHAR)), OptionalInt.of(8192));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)1024));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        int batchSize = 8192;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() <= 0x400000L) continue;
            batchSize /= 2;
        }
        Arrays.fill(slices, Slices.allocate((int)128));
        inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
        outputPages = ImmutableList.copyOf(output);
        int offset = 0;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, Math.min(inputPage.getPositionCount() - offset, batchSize)))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            offset += ((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getPositionCount();
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() >= 0x100000L) continue;
            batchSize *= 2;
        }
    }

    @Test
    public void testOptimisticProcessing() {
        InvocationCountPageProjection firstProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR));
        InvocationCountPageProjection secondProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)firstProjection, (Object)secondProjection), OptionalInt.of(8192));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)1024));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        int batchSize = 8192;
        while (inputPage.getBlock(0).getRegionSizeInBytes(0, batchSize) > 0x400000L) {
            batchSize /= 2;
        }
        int pageCount = 0;
        while (output.hasNext()) {
            Page actualPage = output.next().orElse(null);
            Block sliceBlock = BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize));
            Page expectedPage = new Page(new Block[]{sliceBlock, sliceBlock});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), actualPage, expectedPage);
            ++pageCount;
            if (actualPage.getSizeInBytes() <= 0x400000L) continue;
            batchSize /= 2;
        }
        Assert.assertEquals((int)secondProjection.getInvocationCount(), (int)pageCount);
        Assert.assertTrue((firstProjection.getInvocationCount() < secondProjection.getInvocationCount() ? 1 : 0) != 0);
    }

    @Test
    public void testRetainedSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)VarcharType.VARCHAR), (Object)new InputPageProjection(1, (Type)VarcharType.VARCHAR)), OptionalInt.of(8192));
        String value = String.join((CharSequence)"", Collections.nCopies(10000, "a"));
        List<String> values = Collections.nCopies(800, value);
        Page inputPage = new Page(new Block[]{BlockAssertions.createStringsBlock(values), BlockAssertions.createStringsBlock(values)});
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), memoryContext, inputPage);
        output.hasNext();
        Assert.assertEquals((long)(memoryContext.getBytes() - (long)ClassLayout.parseClass(VariableWidthBlock.class).instanceSize()), (long)inputPage.getRetainedSizeInBytes());
    }

    @Test
    public void testYieldProjection() {
        int rows = 128;
        int columns = 20;
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Collections.nCopies(columns, new YieldPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR))), OptionalInt.of(8192));
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, yieldSignal, inputPage);
        for (int i = 0; i < columns - 1; ++i) {
            Assert.assertTrue((boolean)output.hasNext());
            Assert.assertNull(output.next().orElse(null));
            Assert.assertTrue((boolean)yieldSignal.isSet());
            yieldSignal.reset();
        }
        Assert.assertTrue((boolean)output.hasNext());
        Page actualPage = output.next().orElse(null);
        Assert.assertNotNull((Object)actualPage);
        Assert.assertTrue((boolean)yieldSignal.isSet());
        yieldSignal.reset();
        Object[] blocks = new Block[columns];
        Arrays.fill(blocks, BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, rows)));
        Page expectedPage = new Page((Block[])blocks);
        PageAssertions.assertPageEquals(Collections.nCopies(columns, VarcharType.VARCHAR), actualPage, expectedPage);
        Assert.assertFalse((boolean)output.hasNext());
    }

    @Test
    public void testExpressionProfiler() {
        CallExpression add10Expression = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.ADD, (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        TestingTicker testingTicker = new TestingTicker();
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler((Metadata)MetadataManager.createTestMetadataManager(), 0);
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)add10Expression, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(1, 11)});
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
        for (int i = 0; i < 100; ++i) {
            profiler.start();
            Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), page, SelectedPositions.positionsRange((int)0, (int)page.getPositionCount()));
            if (i < 10) {
                testingTicker.increment(10L, TimeUnit.SECONDS);
                profiler.stop(page.getPositionCount());
                Assert.assertTrue((boolean)profiler.isExpressionExpensive());
            } else {
                testingTicker.increment(0L, TimeUnit.NANOSECONDS);
                profiler.stop(page.getPositionCount());
                Assert.assertFalse((boolean)profiler.isExpressionExpensive());
            }
            work.process();
        }
    }

    @Test
    public void testIncreasingBatchSize() {
        int rows = 1024;
        TestingTicker testingTicker = new TestingTicker();
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(1), profiler);
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        long previousPositionCount = 1L;
        long totalPositionCount = 0L;
        while (totalPositionCount < (long)rows) {
            Optional<Page> page = output.next();
            Assert.assertTrue((boolean)page.isPresent());
            long positionCount = page.get().getPositionCount();
            if (positionCount > 1L && (totalPositionCount += positionCount) != (long)rows) {
                Assert.assertEquals((long)positionCount, (long)(previousPositionCount * 2L));
            }
            previousPositionCount = positionCount;
        }
    }

    @Test
    public void testDecreasingBatchSize() {
        int rows = 1024;
        TestingTicker testingTicker = new TestingTicker();
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, new Duration(0.0, TimeUnit.MILLISECONDS));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(512), profiler);
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        long previousPositionCount = 1L;
        long totalPositionCount = 0L;
        while (totalPositionCount < (long)rows) {
            Optional<Page> page = output.next();
            Assert.assertTrue((boolean)page.isPresent());
            long positionCount = page.get().getPositionCount();
            totalPositionCount += positionCount;
            if (positionCount > 1L && previousPositionCount != 1L) {
                Assert.assertEquals((long)positionCount, (long)(previousPositionCount / 2L));
            }
            previousPositionCount = positionCount;
        }
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, Page inputPage) {
        return this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, DriverYieldSignal yieldSignal, Page inputPage) {
        return this.processAndAssertRetainedPageSize(pageProcessor, yieldSignal, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), inputPage);
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, DriverYieldSignal yieldSignal, AggregatedMemoryContext memoryContext, Page inputPage) {
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, yieldSignal, memoryContext.newLocalMemoryContext(PageProcessor.class.getSimpleName()), inputPage);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
        return output;
    }

    private static class SelectNoneFilter
    implements PageFilter {
        private SelectNoneFilter() {
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)0);
        }
    }

    public static class SelectAllFilter
    implements PageFilter {
        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)page.getPositionCount());
        }
    }

    private static class TestingPageFilter
    implements PageFilter {
        private final SelectedPositions selectedPositions;

        public TestingPageFilter(SelectedPositions selectedPositions) {
            this.selectedPositions = selectedPositions;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return this.selectedPositions;
        }
    }

    public static class LazyPagePageProjection
    implements PageProjection {
        public Type getType() {
            return BigintType.BIGINT;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0, 1});
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new CompletedWork((Object)page.getBlock(0).getLoadedBlock());
        }
    }

    private class YieldPageProjection
    extends InvocationCountPageProjection {
        public YieldPageProjection(PageProjection delegate) {
            super(delegate);
        }

        @Override
        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new YieldPageProjectionWork(session, yieldSignal, page, selectedPositions);
        }

        private class YieldPageProjectionWork
        implements Work<Block> {
            private final DriverYieldSignal yieldSignal;
            private final Work<Block> work;

            public YieldPageProjectionWork(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
                this.yieldSignal = yieldSignal;
                this.work = YieldPageProjection.this.delegate.project(session, yieldSignal, page, selectedPositions);
            }

            public boolean process() {
                Assert.assertTrue((boolean)this.work.process());
                this.yieldSignal.setWithDelay(1L, TestPageProcessor.this.executor);
                this.yieldSignal.forceYieldForTesting();
                return true;
            }

            public Block getResult() {
                return (Block)this.work.getResult();
            }
        }
    }

    private static class InvocationCountPageProjection
    implements PageProjection {
        protected final PageProjection delegate;
        private int invocationCount;

        public InvocationCountPageProjection(PageProjection delegate) {
            this.delegate = delegate;
        }

        public Type getType() {
            return this.delegate.getType();
        }

        public boolean isDeterministic() {
            return this.delegate.isDeterministic();
        }

        public InputChannels getInputChannels() {
            return this.delegate.getInputChannels();
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.setInvocationCount(this.getInvocationCount() + 1);
            return this.delegate.project(session, yieldSignal, page, selectedPositions);
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(int invocationCount) {
            this.invocationCount = invocationCount;
        }
    }
}

