/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.FunctionExtractor;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.FunctionAssertions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.DecimalParseResult;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import java.io.Closeable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestFunctions {
    protected final Session session;
    private final FeaturesConfig config;
    protected FunctionAssertions functionAssertions;

    protected AbstractTestFunctions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    protected AbstractTestFunctions(Session session) {
        this(session, new FeaturesConfig());
    }

    protected AbstractTestFunctions(FeaturesConfig config) {
        this(SessionTestUtils.TEST_SESSION, config);
    }

    protected AbstractTestFunctions(Session session, FeaturesConfig config) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    @BeforeClass
    public final void initTestFunctions() {
        this.functionAssertions = new FunctionAssertions(this.session, this.config);
    }

    @AfterClass(alwaysRun=true)
    public final void destroyTestFunctions() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.functionAssertions});
        this.functionAssertions = null;
    }

    protected void assertFunction(String projection, Type expectedType, Object expected) {
        this.functionAssertions.assertFunction(projection, expectedType, expected);
    }

    protected void assertOperator(OperatorType operator, String value, Type expectedType, Object expected) {
        this.functionAssertions.assertFunction(String.format("\"%s\"(%s)", FunctionRegistry.mangleOperatorName((OperatorType)operator), value), expectedType, expected);
    }

    protected void assertDecimalFunction(String statement, SqlDecimal expectedResult) {
        this.assertFunction(statement, (Type)DecimalType.createDecimalType((int)expectedResult.getPrecision(), (int)expectedResult.getScale()), expectedResult);
    }

    @Deprecated
    protected void assertInvalidFunction(String projection) {
        this.functionAssertions.assertInvalidFunction(projection);
    }

    protected void assertInvalidFunction(String projection, StandardErrorCode errorCode, String messagePattern) {
        this.functionAssertions.assertInvalidFunction(projection, errorCode, messagePattern);
    }

    protected void assertInvalidFunction(String projection, String messagePattern) {
        this.functionAssertions.assertInvalidFunction(projection, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, messagePattern);
    }

    protected void assertInvalidFunction(String projection, SemanticErrorCode expectedErrorCode) {
        this.functionAssertions.assertInvalidFunction(projection, expectedErrorCode);
    }

    protected void assertInvalidFunction(String projection, SemanticErrorCode expectedErrorCode, String message) {
        this.functionAssertions.assertInvalidFunction(projection, expectedErrorCode, message);
    }

    protected void assertInvalidFunction(String projection, ErrorCodeSupplier expectedErrorCode) {
        this.functionAssertions.assertInvalidFunction(projection, expectedErrorCode);
    }

    protected void assertNumericOverflow(String projection, String message) {
        this.functionAssertions.assertNumericOverflow(projection, message);
    }

    protected void assertInvalidCast(String projection) {
        this.functionAssertions.assertInvalidCast(projection);
    }

    protected void assertInvalidCast(String projection, String message) {
        this.functionAssertions.assertInvalidCast(projection, message);
    }

    public void assertCachedInstanceHasBoundedRetainedSize(String projection) {
        this.functionAssertions.assertCachedInstanceHasBoundedRetainedSize(projection);
    }

    protected void assertNotSupported(String projection, String message) {
        try {
            this.functionAssertions.executeProjectionWithFullEngine(projection);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    protected void tryEvaluateWithAll(String projection, Type expectedType) {
        this.functionAssertions.tryEvaluateWithAll(projection, expectedType);
    }

    protected void registerScalarFunction(SqlScalarFunction sqlScalarFunction) {
        Metadata metadata = this.functionAssertions.getMetadata();
        metadata.getFunctionRegistry().addFunctions((List)ImmutableList.of((Object)sqlScalarFunction));
    }

    protected void registerScalar(Class<?> clazz) {
        Metadata metadata = this.functionAssertions.getMetadata();
        List functions = new FunctionListBuilder().scalars(clazz).getFunctions();
        metadata.getFunctionRegistry().addFunctions(functions);
    }

    protected void registerParametricScalar(Class<?> clazz) {
        Metadata metadata = this.functionAssertions.getMetadata();
        List functions = new FunctionListBuilder().scalar(clazz).getFunctions();
        metadata.getFunctionRegistry().addFunctions(functions);
    }

    protected void registerFunctions(Plugin plugin) {
        this.functionAssertions.getMetadata().addFunctions(FunctionExtractor.extractFunctions((Collection)plugin.getFunctions()));
    }

    protected void registerTypes(Plugin plugin) {
        for (Type type : plugin.getTypes()) {
            this.functionAssertions.getTypeRegistry().addType(type);
        }
    }

    protected static SqlDecimal decimal(String decimalString) {
        DecimalParseResult parseResult = Decimals.parseIncludeLeadingZerosInPrecision((String)decimalString);
        BigInteger unscaledValue = parseResult.getType().isShort() ? BigInteger.valueOf((Long)parseResult.getObject()) : Decimals.decodeUnscaledValue((Slice)((Slice)parseResult.getObject()));
        return new SqlDecimal(unscaledValue, parseResult.getType().getPrecision(), parseResult.getType().getScale());
    }

    protected static SqlDecimal maxPrecisionDecimal(long value) {
        String maxPrecisionFormat = "%0" + (38 + (value < 0L ? 1 : 0)) + "d";
        return AbstractTestFunctions.decimal(String.format(maxPrecisionFormat, value));
    }

    protected static Map asMap(List keyList, List valueList) {
        if (keyList.size() != valueList.size()) {
            Assert.fail((String)"keyList should have same size with valueList");
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keyList.size(); ++i) {
            if (map.put(keyList.get(i), valueList.get(i)) == null) continue;
            Assert.fail((String)"keyList should have same size with valueList");
        }
        return map;
    }
}

