/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.scalar.CombineHashFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayHashCodeOperator {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 100;
    private static final int NUM_TYPES = 4;

    @Benchmark
    @OperationsPerInvocation(value=40000000)
    public List<Optional<Page>> arrayHashCode(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayHashCodeOperator().arrayHashCode(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.BULK).include(".*" + BenchmarkArrayHashCodeOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @ScalarFunction(value="another_hash")
    @Description(value="Only for benchmark array hash code operator")
    public static final class BenchmarkAnotherArrayHash {
        private BenchmarkAnotherArrayHash() {
        }

        @TypeParameter(value="T")
        @SqlType(value="bigint")
        public static long anotherHash(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
            int hash = 0;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                TypeUtils.checkElementNotNull((boolean)block.isNull(i), (String)"ARRAY comparison not supported for arrays with null elements");
                hash = (int)CombineHashFunction.getHash((long)hash, (long)TypeUtils.hashPosition((MethodHandle)hashFunction, (Type)type, (Block)block, (int)i));
            }
            return hash;
        }
    }

    @ScalarFunction(value="old_hash")
    @Description(value="Only for benchmark array hash code operator")
    public static final class BenchmarkOldArrayHash {
        private BenchmarkOldArrayHash() {
        }

        @TypeParameter(value="T")
        @SqlType(value="bigint")
        public static long oldHash(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
            int hash = 0;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                TypeUtils.checkElementNotNull((boolean)block.isNull(i), (String)"ARRAY comparison not supported for arrays with null elements");
                hash = (int)CombineHashFunction.getHash((long)hash, (long)type.hash(block, i));
            }
            return hash;
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"$operator$hash_code", "old_hash", "another_hash"})
        private String name = FunctionRegistry.mangleOperatorName((OperatorType)OperatorType.HASH_CODE);
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String type = "BIGINT";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            BigintType elementType;
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            metadata.addFunctions(new FunctionListBuilder().scalar(BenchmarkOldArrayHash.class).getFunctions());
            metadata.addFunctions(new FunctionListBuilder().scalar(BenchmarkAnotherArrayHash.class).getFunctions());
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[1];
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    break;
                }
                case "BOOLEAN": {
                    elementType = BooleanType.BOOLEAN;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            ArrayType arrayType = new ArrayType((Type)elementType);
            Signature signature = new Signature(this.name, FunctionKind.SCALAR, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature()});
            projectionsBuilder.add((Object)new CallExpression(signature, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType))));
            blocks[0] = BenchmarkData.createChannel(100000, 100, arrayType);
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (arrayType.getElementType().getJavaType() == Long.TYPE) {
                        arrayType.getElementType().writeLong(entryBuilder, ThreadLocalRandom.current().nextLong());
                        continue;
                    }
                    if (arrayType.getElementType().getJavaType() == Double.TYPE) {
                        arrayType.getElementType().writeDouble(entryBuilder, ThreadLocalRandom.current().nextDouble());
                        continue;
                    }
                    if (arrayType.getElementType().getJavaType() == Boolean.TYPE) {
                        arrayType.getElementType().writeBoolean(entryBuilder, ThreadLocalRandom.current().nextBoolean());
                        continue;
                    }
                    if (arrayType.getElementType().equals(VarcharType.VARCHAR)) {
                        arrayType.getElementType().writeSlice(entryBuilder, Slices.utf8Slice((String)"test_string"));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

