/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockAssertions;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.ArrayBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.testing.TestingConnectorSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArraySubscript {
    private static final int POSITIONS = 1024;

    @Benchmark
    @OperationsPerInvocation(value=1024)
    public List<Optional<Page>> arraySubscript(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArraySubscript().arraySubscript(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.INDI).include(".*" + BenchmarkArraySubscript.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"fix-width", "var-width", "dictionary", "array"})
        private String name = "dictionary";
        @Param(value={"1", "13"})
        private int arraySize = 13;
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            Block elementsBlock;
            ArrayType arrayType;
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            switch (this.name) {
                case "fix-width": {
                    arrayType = new ArrayType((Type)DoubleType.DOUBLE);
                    elementsBlock = BenchmarkData.createFixWidthValueBlock(1024, this.arraySize);
                    break;
                }
                case "var-width": {
                    arrayType = new ArrayType((Type)VarcharType.createUnboundedVarcharType());
                    elementsBlock = BenchmarkData.createVarWidthValueBlock(1024, this.arraySize);
                    break;
                }
                case "dictionary": {
                    arrayType = new ArrayType((Type)VarcharType.createUnboundedVarcharType());
                    elementsBlock = BenchmarkData.createDictionaryValueBlock(1024, this.arraySize);
                    break;
                }
                case "array": {
                    arrayType = new ArrayType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()));
                    elementsBlock = BenchmarkData.createArrayBlock(1024 * this.arraySize, BenchmarkData.createVarWidthValueBlock(1024, this.arraySize));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            Block block = BenchmarkData.createArrayBlock(1024, elementsBlock);
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Signature signature = new Signature("$operator$" + OperatorType.SUBSCRIPT.name(), FunctionKind.SCALAR, arrayType.getElementType().getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature(), BigintType.BIGINT.getTypeSignature()});
            for (int i = 0; i < this.arraySize; ++i) {
                projectionsBuilder.add((Object)new CallExpression(signature, arrayType.getElementType(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.constant((Object)((long)i + 1L), (Type)BigintType.BIGINT))));
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{block});
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }

        private static Block createArrayBlock(int positionCount, Block elementsBlock) {
            int[] offsets = new int[positionCount + 1];
            int arraySize = elementsBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = arraySize * i;
            }
            return ArrayBlock.fromElementBlock((int)positionCount, Optional.empty(), (int[])offsets, (Block)elementsBlock);
        }

        private static Block createFixWidthValueBlock(int positionCount, int mapSize) {
            BlockBuilder valueBlockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                DoubleType.DOUBLE.writeDouble(valueBlockBuilder, ThreadLocalRandom.current().nextDouble());
            }
            return valueBlockBuilder.build();
        }

        private static Block createVarWidthValueBlock(int positionCount, int mapSize) {
            VarcharType valueType = VarcharType.createUnboundedVarcharType();
            BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                int wordLength = ThreadLocalRandom.current().nextInt(5, 10);
                valueType.writeSlice(valueBlockBuilder, Slices.utf8Slice((String)BenchmarkData.randomString(wordLength)));
            }
            return valueBlockBuilder.build();
        }

        private static Block createDictionaryValueBlock(int positionCount, int mapSize) {
            double distinctRatio = 0.82;
            int dictionarySize = (int)((double)(positionCount * mapSize) * distinctRatio);
            ArrayList<String> dictionaryStrings = new ArrayList<String>(dictionarySize);
            for (int i = 0; i < dictionarySize; ++i) {
                int wordLength = ThreadLocalRandom.current().nextInt(5, 10);
                dictionaryStrings.add(BenchmarkData.randomString(wordLength));
            }
            Block dictionaryBlock = BenchmarkData.createSliceArrayBlock(dictionaryStrings);
            int[] keyIds = new int[positionCount * mapSize];
            for (int i = 0; i < keyIds.length; ++i) {
                keyIds[i] = ThreadLocalRandom.current().nextInt(0, dictionarySize);
            }
            return new DictionaryBlock(dictionaryBlock, keyIds);
        }

        private static String randomString(int length) {
            String symbols = "abcdefghijklmnopqrstuvwxyz";
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = symbols.charAt(ThreadLocalRandom.current().nextInt(symbols.length()));
            }
            return new String(chars);
        }

        private static Block createSliceArrayBlock(List<String> keys) {
            Slice[] sliceArray = new Slice[keys.size() + 1];
            for (int i = 0; i < keys.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)keys.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }
    }
}

