/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkRowToRowCast {
    private static final int POSITION_COUNT = 100000;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkRowToRowCast().benchmark(data);
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkRowToRowCast().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkRowToRowCast.class.getSimpleName() + ".*").warmupMode(WarmupMode.INDI).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final List<Type> fromFieldTypes = ImmutableList.of((Object)VarcharType.createVarcharType((int)20), (Object)BigintType.BIGINT);
        private static final List<Type> toFieldTypes = ImmutableList.of((Object)VarcharType.createVarcharType((int)30), (Object)BigintType.BIGINT);
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            Signature signature = new Signature("$operator$CAST", FunctionKind.SCALAR, RowType.anonymous(fromFieldTypes).getTypeSignature(), new TypeSignature[]{RowType.anonymous(toFieldTypes).getTypeSignature()});
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(signature, (Type)RowType.anonymous(fromFieldTypes), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)RowType.anonymous(toFieldTypes)))));
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            this.pageProcessor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0)).compilePageProcessor(Optional.empty(), (List)projections).get();
            Block[] fieldBlocks = (Block[])fromFieldTypes.stream().map(type -> BenchmarkData.createBlock(100000, type)).toArray(Block[]::new);
            Block rowBlock = RowBlock.fromFieldBlocks((int)100000, Optional.empty(), (Block[])fieldBlocks);
            this.page = new Page(new Block[]{rowBlock});
        }

        private static Block createBlock(int positionCount, Type type) {
            BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
            if (type instanceof VarcharType) {
                for (int i = 0; i < positionCount; ++i) {
                    type.writeSlice(blockBuilder, Slices.utf8Slice((String)String.valueOf(ThreadLocalRandom.current().nextInt())));
                }
            } else if (type == BigintType.BIGINT) {
                for (int i = 0; i < positionCount; ++i) {
                    type.writeLong(blockBuilder, ThreadLocalRandom.current().nextLong());
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

