/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Preconditions;
import io.airlift.joni.Regex;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.JoniRegexpCasts;
import io.prestosql.operator.scalar.JoniRegexpFunctions;
import io.prestosql.operator.scalar.Re2JRegexpFunctions;
import io.prestosql.type.Re2JRegexp;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class RegexpFunctionsBenchmark {
    @Benchmark
    public boolean benchmarkLikeJoni(DotStarAroundData data) {
        return JoniRegexpFunctions.regexpLike((Slice)data.getSource(), (Regex)data.getJoniPattern());
    }

    @Benchmark
    public boolean benchmarkLikeRe2J(DotStarAroundData data) {
        return Re2JRegexpFunctions.regexpLike((Slice)data.getSource(), (Re2JRegexp)data.getRe2JPattern());
    }

    private static Re2JRegexp re2JRegexp(Slice pattern) {
        return new Re2JRegexp(Integer.MAX_VALUE, 5, pattern);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + RegexpFunctionsBenchmark.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class DotStarAroundData {
        @Param(value={".*x.*", ".*(x|y).*", "longdotstar", "phone", "literal"})
        private String patternString;
        @Param(value={"1024", "32768"})
        private int sourceLength;
        private Regex joniPattern;
        private Re2JRegexp re2JPattern;
        private Slice source;

        @Setup
        public void setup() {
            Slice pattern;
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(this.sourceLength);
            switch (this.patternString) {
                case ".*x.*": {
                    pattern = Slices.utf8Slice((String)".*x.*");
                    IntStream.generate(() -> 97).limit(this.sourceLength).forEach(arg_0 -> ((SliceOutput)sliceOutput).appendByte(arg_0));
                    break;
                }
                case ".*(x|y).*": {
                    pattern = Slices.utf8Slice((String)".*(x|y).*");
                    IntStream.generate(() -> 97).limit(this.sourceLength).forEach(arg_0 -> ((SliceOutput)sliceOutput).appendByte(arg_0));
                    break;
                }
                case "longdotstar": {
                    pattern = Slices.utf8Slice((String)".*coolfunctionname.*");
                    ThreadLocalRandom.current().ints(97, 123).limit(this.sourceLength).forEach(arg_0 -> ((SliceOutput)sliceOutput).appendByte(arg_0));
                    break;
                }
                case "phone": {
                    pattern = Slices.utf8Slice((String)"\\d{3}/\\d{3}/\\d{4}");
                    ThreadLocalRandom.current().ints(47, 58).limit(this.sourceLength).forEach(arg_0 -> ((SliceOutput)sliceOutput).appendByte(arg_0));
                    break;
                }
                case "literal": {
                    pattern = Slices.utf8Slice((String)"literal");
                    ThreadLocalRandom.current().ints(97, 123).limit(this.sourceLength).forEach(arg_0 -> ((SliceOutput)sliceOutput).appendByte(arg_0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("pattern: " + this.patternString + " not supported");
                }
            }
            this.joniPattern = JoniRegexpCasts.joniRegexp((Slice)pattern);
            this.re2JPattern = RegexpFunctionsBenchmark.re2JRegexp(pattern);
            this.source = sliceOutput.slice();
            Preconditions.checkState((this.source.length() == this.sourceLength ? 1 : 0) != 0, (String)"source.length=%s, sourceLength=%s", (int)this.source.length(), (int)this.sourceLength);
        }

        public Slice getSource() {
            return this.source;
        }

        public Regex getJoniPattern() {
            return this.joniPattern;
        }

        public Re2JRegexp getRe2JPattern() {
            return this.re2JPattern;
        }
    }
}

