/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import org.testng.annotations.Test;

public class TestBitwiseFunctions
extends AbstractTestFunctions {
    @Test
    public void testBitCount() {
        this.assertFunction("bit_count(0, 64)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bit_count(7, 64)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("bit_count(24, 64)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("bit_count(-8, 64)", (Type)BigintType.BIGINT, 61L);
        this.assertFunction("bit_count(2147483647, 64)", (Type)BigintType.BIGINT, 31L);
        this.assertFunction("bit_count(-2147483648, 64)", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("bit_count(9223372036854775807, 64)", (Type)BigintType.BIGINT, 63L);
        this.assertFunction("bit_count(-9223372036854775807-1, 64)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("bit_count(0, 32)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bit_count(7, 32)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("bit_count(24, 32)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("bit_count(-8, 32)", (Type)BigintType.BIGINT, 29L);
        this.assertFunction("bit_count(2147483647, 32)", (Type)BigintType.BIGINT, 31L);
        this.assertFunction("bit_count(-2147483648, 32)", (Type)BigintType.BIGINT, 1L);
        this.assertInvalidFunction("bit_count(2147483648, 32)", "Number must be representable with the bits specified. 2147483648 can not be represented with 32 bits");
        this.assertInvalidFunction("bit_count(-2147483649, 32)", "Number must be representable with the bits specified. -2147483649 can not be represented with 32 bits");
        this.assertFunction("bit_count(1152921504598458367, 62)", (Type)BigintType.BIGINT, 59L);
        this.assertFunction("bit_count(-1, 62)", (Type)BigintType.BIGINT, 62L);
        this.assertFunction("bit_count(33554132, 26)", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("bit_count(-1, 26)", (Type)BigintType.BIGINT, 26L);
        this.assertInvalidFunction("bit_count(1152921504598458367, 60)", "Number must be representable with the bits specified. 1152921504598458367 can not be represented with 60 bits");
        this.assertInvalidFunction("bit_count(33554132, 25)", "Number must be representable with the bits specified. 33554132 can not be represented with 25 bits");
        this.assertInvalidFunction("bit_count(0, -1)", "Bits specified in bit_count must be between 2 and 64, got -1");
        this.assertInvalidFunction("bit_count(0, 1)", "Bits specified in bit_count must be between 2 and 64, got 1");
        this.assertInvalidFunction("bit_count(0, 65)", "Bits specified in bit_count must be between 2 and 64, got 65");
    }

    @Test
    public void testBitwiseNot() {
        this.assertFunction("bitwise_not(0)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("bitwise_not(-1)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_not(8)", (Type)BigintType.BIGINT, -9L);
        this.assertFunction("bitwise_not(-8)", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("bitwise_not(9223372036854775807)", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        this.assertFunction("bitwise_not(-9223372036854775807-1)", (Type)BigintType.BIGINT, Long.MAX_VALUE);
    }

    @Test
    public void testBitwiseAnd() {
        this.assertFunction("bitwise_and(0, -1)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_and(3, 8)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_and(-4, 12)", (Type)BigintType.BIGINT, 12L);
        this.assertFunction("bitwise_and(60, 21)", (Type)BigintType.BIGINT, 20L);
    }

    @Test
    public void testBitwiseOr() {
        this.assertFunction("bitwise_or(0, -1)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("bitwise_or(3, 8)", (Type)BigintType.BIGINT, 11L);
        this.assertFunction("bitwise_or(-4, 12)", (Type)BigintType.BIGINT, -4L);
        this.assertFunction("bitwise_or(60, 21)", (Type)BigintType.BIGINT, 61L);
    }

    @Test
    public void testBitwiseXor() {
        this.assertFunction("bitwise_xor(0, -1)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("bitwise_xor(3, 8)", (Type)BigintType.BIGINT, 11L);
        this.assertFunction("bitwise_xor(-4, 12)", (Type)BigintType.BIGINT, -16L);
        this.assertFunction("bitwise_xor(60, 21)", (Type)BigintType.BIGINT, 41L);
    }
}

