/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestConditions
extends AbstractTestFunctions {
    @Test
    public void testLike() {
        this.assertFunction("'_monkey_' like 'X_monkeyX_' escape 'X'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'monkey' like 'monkey'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'monkey' like 'mon%'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'monkey' like 'mon_ey'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'monkey' like 'm____y'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'monkey' like 'dain'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'monkey' like 'key'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'_monkey_' like '\\_monkey\\_'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'_monkey_' like 'X_monkeyX_' escape 'X'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'_monkey_' like '_monkey_' escape ''", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'*?.(){}+|^$,\\' like '*?.(){}+|^$,\\' escape ''", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("null like 'monkey'", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'monkey' like null", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'monkey' like 'monkey' escape null", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'_monkey_' not like 'X_monkeyX_' escape 'X'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'monkey' not like 'monkey'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'monkey' not like 'mon%'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'monkey' not like 'mon_ey'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'monkey' not like 'm____y'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'monkey' not like 'dain'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'monkey' not like 'key'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'_monkey_' not like '\\_monkey\\_'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'_monkey_' not like 'X_monkeyX_' escape 'X'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'_monkey_' not like '_monkey_' escape ''", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'*?.(){}+|^$,\\' not like '*?.(){}+|^$,\\' escape ''", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("null not like 'monkey'", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'monkey' not like null", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'monkey' not like 'monkey' escape null", (Type)BooleanType.BOOLEAN, null);
        this.assertInvalidFunction("'monkey' like 'monkey' escape 'foo'", "Escape string must be a single character");
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("NULL IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("NULL IS DISTINCT FROM 1", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("1 IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("1 IS DISTINCT FROM 1", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("1 IS DISTINCT FROM 2", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS NOT DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS NOT DISTINCT FROM 1", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("1 IS NOT DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("1 IS NOT DISTINCT FROM 1", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("1 IS NOT DISTINCT FROM 2", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("3 between 2 and 4", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("3 between 3 and 3", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("3 between 2 and 3", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("3 between 3 and 4", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("3 between 4 and 2", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("2 between 3 and 4", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("5 between 3 and 4", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("null between 2 and 4", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("3 between null and 4", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("3 between 2 and null", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("3 between 3 and 4000000000", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("5 between 3 and 4000000000", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("3 between BIGINT '3' and 4", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("BIGINT '3' between 3 and 4", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'c' between 'b' and 'd'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'c' between 'c' and 'c'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'c' between 'b' and 'c'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'c' between 'c' and 'd'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'c' between 'd' and 'b'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'b' between 'c' and 'd'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'e' between 'c' and 'd'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("null between 'b' and 'd'", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'c' between null and 'd'", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'c' between 'b' and null", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("3 not between 2 and 4", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("3 not between 3 and 3", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("3 not between 2 and 3", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("3 not between 3 and 4", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("3 not between 4 and 2", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("2 not between 3 and 4", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("5 not between 3 and 4", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("null not between 2 and 4", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("3 not between null and 4", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("3 not between 2 and null", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'c' not between 'b' and 'd'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'c' not between 'c' and 'c'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'c' not between 'b' and 'c'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'c' not between 'c' and 'd'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'c' not between 'd' and 'b'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'b' not between 'c' and 'd'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'e' not between 'c' and 'd'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("null not between 'b' and 'd'", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'c' not between null and 'd'", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("'c' not between 'b' and null", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testIn() {
        this.assertFunction("3 in (2, 4, 3, 5)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("3 not in (2, 4, 3, 5)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("3 in (2, 4, 9, 5)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("3 in (2, null, 3, 5)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' in ('bar', 'baz', 'foo', 'blah')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' in ('bar', 'baz', 'buz', 'blah')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' in ('bar', null, 'foo', 'blah')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("(null in (2, null, 3, 5)) is null", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("(3 in (2, null)) is null", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("(null not in (2, null, 3, 5)) is null", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("(3 not in (2, null)) is null", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testInDoesNotShortCircuit() {
        this.assertInvalidFunction("3 in (2, 4, 3, 5 / 0)", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testSearchCase() {
        this.assertFunction("case when true then 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case when true then BIGINT '33' end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case when false then 1 else 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case when false then 10000000000 else 33 end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case when false then 1 when false then 1 when true then 33 else 1 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case when false then BIGINT '1' when false then 1 when true then 33 else 1 end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case when false then 10000000000 when false then 1 when true then 33 else 1 end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case when false then 1 end", (Type)IntegerType.INTEGER, null);
        this.assertFunction("case when true then null else 'foo' end", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("case when null then 1 when true then 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case when null then 10000000000 when true then 33 end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case when false then 1.0E0 when true then 33 end", (Type)DoubleType.DOUBLE, 33.0);
        this.assertDecimalFunction("case when false then DECIMAL '2.2' when true then DECIMAL '2.2' end", TestConditions.decimal("2.2"));
        this.assertDecimalFunction("case when false then DECIMAL '1234567890.0987654321' when true then DECIMAL '3.3' end", TestConditions.decimal("0000000003.3000000000"));
        this.assertDecimalFunction("case when false then 1 when true then DECIMAL '2.2' end", TestConditions.decimal("0000000002.2"));
        this.assertDecimalFunction("case when false then 2.2 when true then 2.2 end", TestConditions.decimal("2.2"));
        this.assertDecimalFunction("case when false then 1234567890.0987654321 when true then 3.3 end", TestConditions.decimal("0000000003.3000000000"));
        this.assertDecimalFunction("case when false then 1 when true then 2.2 end", TestConditions.decimal("0000000002.2"));
        this.assertFunction("case when false then DECIMAL '1.1' when true then 33.0E0 end", (Type)DoubleType.DOUBLE, 33.0);
        this.assertFunction("case when false then 1.1 when true then 33.0E0 end", (Type)DoubleType.DOUBLE, 33.0);
    }

    @Test
    public void testSimpleCase() {
        this.assertFunction("case true when true then cast(null as varchar) else 'foo' end", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("case true when true then 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case true when true then BIGINT '33' end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case true when false then 1 else 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case true when false then 10000000000 else 33 end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case true when false then 1 when false then 1 when true then 33 else 1 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case true when false then 1 end", (Type)IntegerType.INTEGER, null);
        this.assertFunction("case true when true then null else 'foo' end", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("case true when null then 10000000000 when true then 33 end", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("case true when null then 1 when true then 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case null when true then 1 else 33 end", (Type)IntegerType.INTEGER, 33);
        this.assertFunction("case true when false then 1.0E0 when true then 33 end", (Type)DoubleType.DOUBLE, 33.0);
        this.assertDecimalFunction("case true when false then DECIMAL '2.2' when true then DECIMAL '2.2' end", TestConditions.decimal("2.2"));
        this.assertDecimalFunction("case true when false then DECIMAL '1234567890.0987654321' when true then DECIMAL '3.3' end", TestConditions.decimal("0000000003.3000000000"));
        this.assertDecimalFunction("case true when false then 1 when true then DECIMAL '2.2' end", TestConditions.decimal("0000000002.2"));
        this.assertFunction("case true when false then DECIMAL '1.1' when true then 33.0E0 end", (Type)DoubleType.DOUBLE, 33.0);
        this.assertDecimalFunction("case true when false then 2.2 when true then 2.2 end", TestConditions.decimal("2.2"));
        this.assertDecimalFunction("case true when false then 1234567890.0987654321 when true then 3.3 end", TestConditions.decimal("0000000003.3000000000"));
        this.assertDecimalFunction("case true when false then 1 when true then 2.2 end", TestConditions.decimal("0000000002.2"));
        this.assertFunction("case true when false then 1.1 when true then 33.0E0 end", (Type)DoubleType.DOUBLE, 33.0);
    }
}

