/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapZipWithFunction
extends AbstractTestFunctions {
    @Test
    public void testRetainedSizeBounded() {
        this.assertCachedInstanceHasBoundedRetainedSize("map_zip_with(map(ARRAY [25, 26, 27], ARRAY [25, 26, 27]), map(ARRAY [24, 25, 26], ARRAY [24, 25, 26]), (k, v1, v2) -> v1 + v2)");
    }

    @Test
    public void testBasic() throws Exception {
        this.assertFunction("map_zip_with(map(ARRAY [1, 2, 3], ARRAY [10, 20, 30]), map(ARRAY [1, 2, 3], ARRAY [1, 4, 9]), (k, v1, v2) -> k + v1 + v2)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)12, (Object)2, (Object)26, (Object)3, (Object)42));
        this.assertFunction("map_zip_with(map(ARRAY ['a', 'b'], ARRAY [1, 2]), map(ARRAY ['c', 'd'], ARRAY [30, 40]), (k, v1, v2) -> v1)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), TestMapZipWithFunction.asMap(Arrays.asList("a", "b", "c", "d"), Arrays.asList(1, 2, null, null)));
        this.assertFunction("map_zip_with(map(ARRAY ['a', 'b'], ARRAY [1, 2]), map(ARRAY ['c', 'd'], ARRAY [30, 40]), (k, v1, v2) -> v2)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), TestMapZipWithFunction.asMap(Arrays.asList("a", "b", "c", "d"), Arrays.asList(null, null, 30, 40)));
        this.assertFunction("map_zip_with(map(ARRAY ['a', 'b', 'c'], ARRAY [1, 2, 3]), map(ARRAY ['b', 'c', 'd', 'e'], ARRAY ['x', 'y', 'z', null]), (k, v1, v2) -> (v1, v2))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)1)))), ImmutableMap.of((Object)"a", Arrays.asList(1, null), (Object)"b", (Object)ImmutableList.of((Object)2, (Object)"x"), (Object)"c", (Object)ImmutableList.of((Object)3, (Object)"y"), (Object)"d", Arrays.asList(null, "z"), (Object)"e", Arrays.asList(null, null)));
    }

    @Test
    public void testTypes() throws Exception {
        this.assertFunction("map_zip_with(map(ARRAY [25, 26, 27], ARRAY [25, 26, 27]), map(ARRAY [25, 26, 27], ARRAY [1, 2, 3]), (k, v1, v2) -> v1 * v2 - k)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)25, (Object)0, (Object)26, (Object)26, (Object)27, (Object)54));
        this.assertFunction("map_zip_with(map(ARRAY [25.5E0, 26.75E0, 27.875E0], ARRAY [25, 26, 27]), map(ARRAY [25.5E0, 26.75E0, 27.875E0], ARRAY [1, 2, 3]), (k, v1, v2) -> v1 + v2 - k)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)0.5, (Object)26.75, (Object)1.25, (Object)27.875, (Object)2.125));
        this.assertFunction("map_zip_with(map(ARRAY [true, false], ARRAY [25, 26]), map(ARRAY [true, false], ARRAY [1, 2]), (k, v1, v2) -> k AND v1 % v2 = 0)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)true, (Object)true, (Object)false, (Object)false));
        this.assertFunction("map_zip_with(map(ARRAY ['s0', 's1', 's2'], ARRAY [25, 26, 27]), map(ARRAY ['s0', 's1', 's2'], ARRAY [1, 2, 3]), (k, v1, v2) -> k || ':' || CAST(v1/v2 AS VARCHAR))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"s0", (Object)"s0:25", (Object)"s1", (Object)"s1:13", (Object)"s2", (Object)"s2:9"));
        this.assertFunction("map_zip_with(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [25, 26]), map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [5, 6]), (k, v1, v2) -> if(v1 % v2 = 0, reverse(k), k))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)2, (Object)1), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)3, (Object)4)));
    }
}

