/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockAssertions;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.DeterminismEvaluator;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.RowExpression;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPageProcessorCompiler {
    private MetadataManager metadataManager;
    private ExpressionCompiler compiler;

    @BeforeClass
    public void setup() {
        this.metadataManager = MetadataManager.createTestMetadataManager();
        this.compiler = new ExpressionCompiler((Metadata)this.metadataManager, new PageFunctionCompiler((Metadata)this.metadataManager, 0));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.metadataManager = null;
        this.compiler = null;
    }

    @Test
    public void testNoCaching() {
        ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        Signature signature = new Signature("concat", FunctionKind.SCALAR, arrayType.getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature(), arrayType.getTypeSignature()});
        projectionsBuilder.add((Object)new CallExpression(signature, (Type)arrayType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.field((int)1, (Type)arrayType))));
        ImmutableList projections = projectionsBuilder.build();
        PageProcessor pageProcessor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
        PageProcessor pageProcessor2 = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
        Assert.assertTrue((pageProcessor != pageProcessor2 ? 1 : 0) != 0);
    }

    @Test
    public void testSanityRLE() {
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT), (Object)Expressions.field((int)1, (Type)VarcharType.VARCHAR)), 8192).get();
        Slice varcharValue = Slices.utf8Slice((String)"hello");
        Page page = new Page(new Block[]{RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)123L, (int)100), RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)varcharValue, (int)100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof RunLengthEncodedBlock));
        Assert.assertTrue((boolean)(outputPage.getBlock(1) instanceof RunLengthEncodedBlock));
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)outputPage.getBlock(0);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(rleBlock.getValue(), 0), (long)123L);
        RunLengthEncodedBlock rleBlock1 = (RunLengthEncodedBlock)outputPage.getBlock(1);
        Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(rleBlock1.getValue(), 0), (Object)varcharValue);
    }

    @Test
    public void testSanityFilterOnDictionary() {
        CallExpression lengthVarchar = new CallExpression(new Signature("length", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)));
        Signature lessThan = Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression filter = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)lengthVarchar, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)), 8192).get();
        Page page = new Page(new Block[]{TestPageProcessorCompiler.createDictionaryBlock(TestPageProcessorCompiler.createExpectedValues(10), 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock = (DictionaryBlock)outputPage.getBlock(0);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)10);
        Page outputPage2 = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage2.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage2.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock2 = (DictionaryBlock)outputPage2.getBlock(0);
        Assert.assertEquals((Object)dictionaryBlock2.getDictionary(), (Object)dictionaryBlock.getDictionary());
    }

    @Test
    public void testSanityFilterOnRLE() {
        Signature lessThan = Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression filter = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT)), 8192).get();
        Page page = new Page(new Block[]{BlockAssertions.createRLEBlock(5L, 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof RunLengthEncodedBlock));
        RunLengthEncodedBlock rle = (RunLengthEncodedBlock)outputPage.getBlock(0);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(rle.getValue(), 0), (long)5L);
    }

    @Test
    public void testSanityColumnarDictionary() {
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)), 8192).get();
        Page page = new Page(new Block[]{TestPageProcessorCompiler.createDictionaryBlock(TestPageProcessorCompiler.createExpectedValues(10), 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock = (DictionaryBlock)outputPage.getBlock(0);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)10);
    }

    @Test
    public void testNonDeterministicProject() {
        Signature lessThan = Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression random = new CallExpression(new Signature("random", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}), (Type)BigintType.BIGINT, Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        CallExpression lessThanRandomExpression = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)random));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)lessThanRandomExpression), 8192).get();
        Assert.assertFalse((boolean)new DeterminismEvaluator(this.metadataManager.getFunctionRegistry()).isDeterministic((RowExpression)lessThanRandomExpression));
        Page page = new Page(new Block[]{BlockAssertions.createLongDictionaryBlock(1, 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertFalse((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
    }

    private static DictionaryBlock createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(BlockAssertions.createSlicesBlock(expectedValues), ids);
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestPageProcessorCompiler.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }
}

