/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestScalarParser
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerParametricScalar(GenericWithIncompleteSpecializationNullable.class);
        this.registerParametricScalar(GenericWithIncompleteSpecializationNotNullable.class);
    }

    @Test
    public void testGenericWithIncompleteSpecialization() {
        this.assertFunction("generic_incomplete_specialization_nullable(9876543210)", (Type)BigintType.BIGINT, 9876543210L);
        this.assertFunction("generic_incomplete_specialization_nullable(1.234E0)", (Type)DoubleType.DOUBLE, 1.234);
        this.assertFunction("generic_incomplete_specialization_nullable('abcd')", (Type)VarcharType.createVarcharType((int)4), "abcd");
        this.assertFunction("generic_incomplete_specialization_nullable(true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("generic_incomplete_specialization_nullable(array[1, 2])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("generic_incomplete_specialization_not_nullable(9876543210)", (Type)BigintType.BIGINT, 9876543210L);
        this.assertFunction("generic_incomplete_specialization_not_nullable(1.234E0)", (Type)DoubleType.DOUBLE, 1.234);
        this.assertFunction("generic_incomplete_specialization_not_nullable('abcd')", (Type)VarcharType.createVarcharType((int)4), "abcd");
        this.assertFunction("generic_incomplete_specialization_not_nullable(true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("generic_incomplete_specialization_not_nullable(array[1, 2])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
    }

    @ScalarFunction(value="generic_incomplete_specialization_not_nullable")
    public static class GenericWithIncompleteSpecializationNotNullable {
        @TypeParameter(value="E")
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlType(value="E") Object input) {
            return input;
        }

        @TypeParameter(value="E")
        @SqlType(value="E")
        public static long specializedSlice(@TypeParameter(value="E") Type type, @SqlType(value="E") long input) {
            return input;
        }
    }

    @ScalarFunction(value="generic_incomplete_specialization_nullable")
    public static class GenericWithIncompleteSpecializationNullable {
        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Object input) {
            return input;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Long specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Long input) {
            return input;
        }
    }
}

