/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.JsonType;
import io.prestosql.type.UnknownType;
import java.util.Arrays;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTryFunction
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long throwError() {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "internal error, should not be suppressed by $internal$try");
    }

    @Test
    public void testBasic() {
        this.assertFunction("\"$internal$try\"(() -> 42)", (Type)IntegerType.INTEGER, 42);
        this.assertFunction("\"$internal$try\"(() -> DOUBLE '4.5')", (Type)DoubleType.DOUBLE, 4.5);
        this.assertFunction("\"$internal$try\"(() -> DECIMAL '4.5')", (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.of((String)"4.5"));
        this.assertFunction("\"$internal$try\"(() -> TRUE)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("\"$internal$try\"(() -> 'hello')", (Type)VarcharType.createVarcharType((int)5), "hello");
        this.assertFunction("\"$internal$try\"(() -> JSON '[true, false, 12, 12.7, \"12\", null]')", (Type)JsonType.JSON, "[true,false,12,12.7,\"12\",null]");
        this.assertFunction("\"$internal$try\"(() -> ARRAY [1, 2])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(1, 2));
        this.assertFunction("\"$internal$try\"(() -> NULL)", (Type)UnknownType.UNKNOWN, null);
    }

    @Test
    public void testExceptions() {
        this.assertFunction("\"$internal$try\"(() -> 1/0)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("\"$internal$try\"(() -> JSON_PARSE('INVALID'))", (Type)JsonType.JSON, null);
        this.assertFunction("\"$internal$try\"(() -> CAST(NULL AS INTEGER))", (Type)IntegerType.INTEGER, null);
        this.assertFunction("\"$internal$try\"(() -> ABS(-9223372036854775807 - 1))", (Type)BigintType.BIGINT, null);
        this.assertInvalidFunction("\"$internal$try\"(() -> throw_error())", (ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR);
    }
}

