/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestWordStemFunction
extends AbstractTestFunctions {
    @Test
    public void testWordStep() {
        this.assertFunction("word_stem('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("word_stem('x')", (Type)VarcharType.createVarcharType((int)1), "x");
        this.assertFunction("word_stem('abc')", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("word_stem('generally')", (Type)VarcharType.createVarcharType((int)9), "general");
        this.assertFunction("word_stem('useful')", (Type)VarcharType.createVarcharType((int)6), "use");
        this.assertFunction("word_stem('runs')", (Type)VarcharType.createVarcharType((int)4), "run");
        this.assertFunction("word_stem('run')", (Type)VarcharType.createVarcharType((int)3), "run");
        this.assertFunction("word_stem('authorized', 'en')", (Type)VarcharType.createVarcharType((int)10), "author");
        this.assertFunction("word_stem('accessories', 'en')", (Type)VarcharType.createVarcharType((int)11), "accessori");
        this.assertFunction("word_stem('intensifying', 'en')", (Type)VarcharType.createVarcharType((int)12), "intensifi");
        this.assertFunction("word_stem('resentment')", (Type)VarcharType.createVarcharType((int)10), "resent");
        this.assertFunction("word_stem('faithfulness')", (Type)VarcharType.createVarcharType((int)12), "faith");
        this.assertFunction("word_stem('continuerait', 'fr')", (Type)VarcharType.createVarcharType((int)12), "continu");
        this.assertFunction("word_stem('torpedearon', 'es')", (Type)VarcharType.createVarcharType((int)11), "torped");
        this.assertFunction("word_stem('quilomtricos', 'pt')", (Type)VarcharType.createVarcharType((int)12), "quilomtr");
        this.assertFunction("word_stem('pronunziare', 'it')", (Type)VarcharType.createVarcharType((int)11), "pronunz");
        this.assertFunction("word_stem('auferstnde', 'de')", (Type)VarcharType.createVarcharType((int)10), "auferstnd");
        this.assertInvalidFunction("word_stem('test', 'xx')", "Unknown stemmer language: xx");
    }
}

