/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemGenerator;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.FileSingleStreamSpillerFactory;
import io.prestosql.spiller.GenericSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.spiller.Spiller;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.spiller.SpillerStats;
import io.prestosql.type.TypeRegistry;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkBinaryFileSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.createUnboundedVarcharType(), (Object)DoubleType.DOUBLE);
    private static final BlockEncodingSerde BLOCK_ENCODING_MANAGER = new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]);
    private static final Path SPILL_PATH = Paths.get(System.getProperty("java.io.tmpdir"), "spills");

    @Benchmark
    public void write(BenchmarkData data) throws ExecutionException, InterruptedException {
        try (Spiller spiller = data.createSpiller();){
            spiller.spill(data.getPages().iterator()).get();
        }
    }

    @Benchmark
    public void read(BenchmarkData data) {
        List spills = data.getReadSpiller().getSpills();
        for (Iterator spill : spills) {
            while (spill.hasNext()) {
                Page next = (Page)spill.next();
                next.getPositionCount();
            }
        }
    }

    static /* synthetic */ BlockEncodingSerde access$000() {
        return BLOCK_ENCODING_MANAGER;
    }

    static /* synthetic */ Path access$100() {
        return SPILL_PATH;
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final SpillerStats spillerStats = new SpillerStats();
        private final FileSingleStreamSpillerFactory singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(MoreExecutors.newDirectExecutorService(), BenchmarkBinaryFileSpiller.access$000(), this.spillerStats, (List)ImmutableList.of((Object)BenchmarkBinaryFileSpiller.access$100()), 1.0);
        private final SpillerFactory spillerFactory = new GenericSpillerFactory((SingleStreamSpillerFactory)this.singleStreamSpillerFactory);
        @Param(value={"10000"})
        private int rowsPerPage = 10000;
        @Param(value={"10"})
        private int pagesCount = 10;
        private List<Page> pages;
        private Spiller readSpiller;

        @Setup
        public void setup() throws ExecutionException, InterruptedException {
            this.pages = this.createInputPages();
            this.readSpiller = this.spillerFactory.create(TYPES, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
            this.readSpiller.spill(this.pages.iterator()).get();
        }

        @TearDown
        public void tearDown() {
            this.readSpiller.close();
            this.singleStreamSpillerFactory.destroy();
        }

        private List<Page> createInputPages() {
            ImmutableList.Builder pages = ImmutableList.builder();
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
            for (int j = 0; j < this.pagesCount; ++j) {
                Iterator iterator = lineItemGenerator.iterator();
                for (int i = 0; i < this.rowsPerPage; ++i) {
                    pageBuilder.declarePosition();
                    LineItem lineItem = (LineItem)iterator.next();
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), lineItem.getOrderKey());
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(1), lineItem.getDiscountPercent());
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(2), lineItem.getDiscount());
                    VarcharType.VARCHAR.writeString(pageBuilder.getBlockBuilder(3), lineItem.getReturnFlag());
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), lineItem.getExtendedPrice());
                }
                pages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
            return pages.build();
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public Spiller getReadSpiller() {
            return this.readSpiller;
        }

        public Spiller createSpiller() {
            return this.spillerFactory.create(TYPES, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        }
    }
}

