/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.operator.window.AbstractTestWindowFunction;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.MaterializedResult;
import org.testng.annotations.Test;

public class TestFirstValueFunction
extends AbstractTestWindowFunction {
    @Test
    public void testFirstValueUnbounded() {
        this.assertWindowQuery("first_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-14"}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{6, "F", "1993-10-14"}).row(new Object[]{33, "F", "1993-10-14"}).row(new Object[]{1, "O", "1996-01-02"}).row(new Object[]{2, "O", "1996-01-02"}).row(new Object[]{4, "O", "1996-01-02"}).row(new Object[]{7, "O", "1996-01-02"}).row(new Object[]{32, "O", "1996-01-02"}).row(new Object[]{34, "O", "1996-01-02"}).build());
        this.assertWindowQueryWithNulls("first_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3L, "F", "1993-10-14"}).row(new Object[]{5L, "F", "1993-10-14"}).row(new Object[]{6L, "F", "1993-10-14"}).row(new Object[]{null, "F", "1993-10-14"}).row(new Object[]{34L, "O", "1998-07-21"}).row(new Object[]{null, "O", "1998-07-21"}).row(new Object[]{1L, null, null}).row(new Object[]{7L, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build());
        this.assertWindowQuery("first_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 3}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 3}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 1}).row(new Object[]{4, "O", 1}).row(new Object[]{7, "O", 1}).row(new Object[]{32, "O", 1}).row(new Object[]{34, "O", 1}).build());
        this.assertWindowQueryWithNulls("first_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 3L}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 3L}).row(new Object[]{null, "F", 3L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 1L}).row(new Object[]{7L, null, 1L}).row(new Object[]{null, null, 1L}).row(new Object[]{null, null, 1L}).build());
        this.assertWindowQuery("date_format(first_value(cast(orderdate as TIMESTAMP)) OVER (PARTITION BY orderstatus ORDER BY orderkey), '%Y-%m-%d')", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-14"}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{6, "F", "1993-10-14"}).row(new Object[]{33, "F", "1993-10-14"}).row(new Object[]{1, "O", "1996-01-02"}).row(new Object[]{2, "O", "1996-01-02"}).row(new Object[]{4, "O", "1996-01-02"}).row(new Object[]{7, "O", "1996-01-02"}).row(new Object[]{32, "O", "1996-01-02"}).row(new Object[]{34, "O", "1996-01-02"}).build());
    }

    @Test
    public void testFirstValueBounded() {
        this.assertWindowQuery("first_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, IntegerType.INTEGER}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 3}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 5}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 1}).row(new Object[]{4, "O", 1}).row(new Object[]{7, "O", 2}).row(new Object[]{32, "O", 4}).row(new Object[]{34, "O", 7}).build());
        this.assertWindowQueryWithNulls("first_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3L, "F", 3L}).row(new Object[]{5L, "F", 3L}).row(new Object[]{6L, "F", 3L}).row(new Object[]{null, "F", 5L}).row(new Object[]{34L, "O", 34L}).row(new Object[]{null, "O", 34L}).row(new Object[]{1L, null, 1L}).row(new Object[]{7L, null, 1L}).row(new Object[]{null, null, 1L}).row(new Object[]{null, null, 7L}).build());
    }
}

