/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.operator.window.AbstractTestWindowFunction;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.MaterializedResult;
import org.testng.annotations.Test;

public class TestMultipleWindowSpecifications
extends AbstractTestWindowFunction {
    @Test
    public void testIdenticalWindowSpecifications() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, "F", 1L, 3L}).row(new Object[]{5, "F", 2L, 8L}).row(new Object[]{6, "F", 3L, 14L}).row(new Object[]{33, "F", 4L, 47L}).row(new Object[]{1, "O", 1L, 1L}).row(new Object[]{2, "O", 2L, 3L}).row(new Object[]{4, "O", 3L, 7L}).row(new Object[]{7, "O", 4L, 14L}).row(new Object[]{32, "O", 5L, 46L}).row(new Object[]{34, "O", 6L, 80L}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, "F", 1L, 3L}).row(new Object[]{5L, "F", 2L, 8L}).row(new Object[]{6L, "F", 3L, 14L}).row(new Object[]{null, "F", 3L, 14L}).row(new Object[]{34L, "O", 1L, 34L}).row(new Object[]{null, "O", 1L, 34L}).row(new Object[]{1L, null, 1L, 1L}).row(new Object[]{7L, null, 2L, 8L}).row(new Object[]{null, null, 2L, 8L}).row(new Object[]{null, null, 2L, 8L}).build());
    }

    @Test
    public void testIntersectingWindowSpecifications() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 PRECEDING AND 2 PRECEDING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, "F", 0L, 3L}).row(new Object[]{5, "F", 0L, 8L}).row(new Object[]{6, "F", 1L, 14L}).row(new Object[]{33, "F", 2L, 44L}).row(new Object[]{1, "O", 0L, 1L}).row(new Object[]{2, "O", 0L, 3L}).row(new Object[]{4, "O", 1L, 7L}).row(new Object[]{7, "O", 2L, 13L}).row(new Object[]{32, "O", 2L, 43L}).row(new Object[]{34, "O", 2L, 73L}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 PRECEDING AND 2 PRECEDING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, "F", 0L, 3L}).row(new Object[]{5L, "F", 0L, 8L}).row(new Object[]{6L, "F", 1L, 14L}).row(new Object[]{null, "F", 2L, 11L}).row(new Object[]{34L, "O", 0L, 34L}).row(new Object[]{null, "O", 0L, 34L}).row(new Object[]{1L, null, 0L, 1L}).row(new Object[]{7L, null, 0L, 8L}).row(new Object[]{null, null, 1L, 8L}).row(new Object[]{null, null, 2L, 7L}).build());
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 PRECEDING AND CURRENT ROW), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, "F", 1L, 14L}).row(new Object[]{5, "F", 2L, 44L}).row(new Object[]{6, "F", 2L, 39L}).row(new Object[]{33, "F", 2L, 33L}).row(new Object[]{1, "O", 1L, 7L}).row(new Object[]{2, "O", 2L, 13L}).row(new Object[]{4, "O", 2L, 43L}).row(new Object[]{7, "O", 2L, 73L}).row(new Object[]{32, "O", 2L, 66L}).row(new Object[]{34, "O", 2L, 34L}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 PRECEDING AND CURRENT ROW), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, "F", 1L, 14L}).row(new Object[]{5L, "F", 2L, 11L}).row(new Object[]{6L, "F", 2L, 6L}).row(new Object[]{null, "F", 1L, null}).row(new Object[]{34L, "O", 1L, 34L}).row(new Object[]{null, "O", 1L, null}).row(new Object[]{1L, null, 1L, 8L}).row(new Object[]{7L, null, 2L, 7L}).row(new Object[]{null, null, 1L, null}).row(new Object[]{null, null, 0L, null}).build());
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND 1 FOLLOWING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 FOLLOWING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, "F", 2L, 11L}).row(new Object[]{5, "F", 2L, 39L}).row(new Object[]{6, "F", 2L, 33L}).row(new Object[]{33, "F", 1L, null}).row(new Object[]{1, "O", 2L, 6L}).row(new Object[]{2, "O", 2L, 11L}).row(new Object[]{4, "O", 2L, 39L}).row(new Object[]{7, "O", 2L, 66L}).row(new Object[]{32, "O", 2L, 34L}).row(new Object[]{34, "O", 1L, null}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND 1 FOLLOWING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 FOLLOWING AND 2 FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, "F", 2L, 11L}).row(new Object[]{5L, "F", 2L, 6L}).row(new Object[]{6L, "F", 1L, null}).row(new Object[]{null, "F", 0L, null}).row(new Object[]{34L, "O", 1L, null}).row(new Object[]{null, "O", 0L, null}).row(new Object[]{1L, null, 2L, 7L}).row(new Object[]{7L, null, 1L, null}).row(new Object[]{null, null, 0L, null}).row(new Object[]{null, null, 0L, null}).build());
    }

    @Test
    public void testDisjointWindowSpecifications() {
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 PRECEDING AND 2 PRECEDING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 PRECEDING AND CURRENT ROW)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, "F", 0L, 3L}).row(new Object[]{5, "F", 0L, 8L}).row(new Object[]{6, "F", 1L, 11L}).row(new Object[]{33, "F", 2L, 39L}).row(new Object[]{1, "O", 0L, 1L}).row(new Object[]{2, "O", 0L, 3L}).row(new Object[]{4, "O", 1L, 6L}).row(new Object[]{7, "O", 2L, 11L}).row(new Object[]{32, "O", 2L, 39L}).row(new Object[]{34, "O", 2L, 66L}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 PRECEDING AND 2 PRECEDING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 PRECEDING AND CURRENT ROW)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, "F", 0L, 3L}).row(new Object[]{5L, "F", 0L, 8L}).row(new Object[]{6L, "F", 1L, 11L}).row(new Object[]{null, "F", 2L, 6L}).row(new Object[]{34L, "O", 0L, 34L}).row(new Object[]{null, "O", 0L, 34L}).row(new Object[]{1L, null, 0L, 1L}).row(new Object[]{7L, null, 0L, 8L}).row(new Object[]{null, null, 1L, 7L}).row(new Object[]{null, null, 2L, null}).build());
        this.assertWindowQuery("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 PRECEDING AND 2 PRECEDING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 FOLLOWING AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3, "F", 0L, 44L}).row(new Object[]{5, "F", 0L, 39L}).row(new Object[]{6, "F", 1L, 33L}).row(new Object[]{33, "F", 2L, null}).row(new Object[]{1, "O", 0L, 79L}).row(new Object[]{2, "O", 0L, 77L}).row(new Object[]{4, "O", 1L, 73L}).row(new Object[]{7, "O", 2L, 66L}).row(new Object[]{32, "O", 2L, 34L}).row(new Object[]{34, "O", 2L, null}).build());
        this.assertWindowQueryWithNulls("count(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 3 PRECEDING AND 2 PRECEDING), sum(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey ROWS BETWEEN 1 FOLLOWING AND UNBOUNDED FOLLOWING)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{3L, "F", 0L, 11L}).row(new Object[]{5L, "F", 0L, 6L}).row(new Object[]{6L, "F", 1L, null}).row(new Object[]{null, "F", 2L, null}).row(new Object[]{34L, "O", 0L, null}).row(new Object[]{null, "O", 0L, null}).row(new Object[]{1L, null, 0L, 7L}).row(new Object[]{7L, null, 0L, null}).row(new Object[]{null, null, 1L, null}).row(new Object[]{null, null, 2L, null}).build());
    }
}

