/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.FileBasedSystemAccessControl;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.testing.InterfaceTestUtils;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileBasedSystemAccessControl {
    private static final Identity alice = new Identity("alice", Optional.empty());
    private static final Identity kerberosValidAlice = new Identity("alice", Optional.of(new KerberosPrincipal("alice/example.com@EXAMPLE.COM")));
    private static final Identity kerberosValidNonAsciiUser = new Identity("\u0194\u0194\u0194", Optional.of(new KerberosPrincipal("\u0194\u0194\u0194/example.com@EXAMPLE.COM")));
    private static final Identity kerberosInvalidAlice = new Identity("alice", Optional.of(new KerberosPrincipal("mallory/example.com@EXAMPLE.COM")));
    private static final Identity kerberosValidShare = new Identity("alice", Optional.of(new KerberosPrincipal("valid/example.com@EXAMPLE.COM")));
    private static final Identity kerberosInValidShare = new Identity("alice", Optional.of(new KerberosPrincipal("invalid/example.com@EXAMPLE.COM")));
    private static final Identity validSpecialRegexWildDot = new Identity(".*", Optional.of(new KerberosPrincipal("special/.*@EXAMPLE.COM")));
    private static final Identity validSpecialRegexEndQuote = new Identity("\\E", Optional.of(new KerberosPrincipal("special/\\E@EXAMPLE.COM")));
    private static final Identity invalidSpecialRegex = new Identity("alice", Optional.of(new KerberosPrincipal("special/.*@EXAMPLE.COM")));
    private static final Identity bob = new Identity("bob", Optional.empty());
    private static final Identity admin = new Identity("admin", Optional.empty());
    private static final Identity nonAsciiUser = new Identity("\u0194\u0194\u0194", Optional.empty());
    private static final Set<String> allCatalogs = ImmutableSet.of((Object)"secret", (Object)"open-to-all", (Object)"all-allowed", (Object)"alice-catalog", (Object)"allowed-absent", (Object)"\u0200\u0200\u0200", (Object[])new String[0]);
    private static final QualifiedObjectName aliceTable = new QualifiedObjectName("alice-catalog", "schema", "table");
    private static final QualifiedObjectName aliceView = new QualifiedObjectName("alice-catalog", "schema", "view");
    private static final CatalogSchemaName aliceSchema = new CatalogSchemaName("alice-catalog", "schema");

    @Test
    public void testCanSetUserOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_principal.json");
        try {
            accessControlManager.checkCanSetUser(Optional.empty(), alice.getUser());
            throw new AssertionError((Object)"expected AccessDeniedExeption");
        }
        catch (AccessDeniedException accessDeniedException) {
            accessControlManager.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
            accessControlManager.checkCanSetUser(kerberosValidNonAsciiUser.getPrincipal(), kerberosValidNonAsciiUser.getUser());
            try {
                accessControlManager.checkCanSetUser(kerberosInvalidAlice.getPrincipal(), kerberosInvalidAlice.getUser());
                throw new AssertionError((Object)"expected AccessDeniedExeption");
            }
            catch (AccessDeniedException accessDeniedException2) {
                accessControlManager.checkCanSetUser(kerberosValidShare.getPrincipal(), kerberosValidShare.getUser());
                try {
                    accessControlManager.checkCanSetUser(kerberosInValidShare.getPrincipal(), kerberosInValidShare.getUser());
                    throw new AssertionError((Object)"expected AccessDeniedExeption");
                }
                catch (AccessDeniedException accessDeniedException3) {
                    accessControlManager.checkCanSetUser(validSpecialRegexWildDot.getPrincipal(), validSpecialRegexWildDot.getUser());
                    accessControlManager.checkCanSetUser(validSpecialRegexEndQuote.getPrincipal(), validSpecialRegexEndQuote.getUser());
                    try {
                        accessControlManager.checkCanSetUser(invalidSpecialRegex.getPrincipal(), invalidSpecialRegex.getUser());
                        throw new AssertionError((Object)"expected AccessDeniedExeption");
                    }
                    catch (AccessDeniedException accessDeniedException4) {
                        TransactionManager transactionManagerNoPatterns = InMemoryTransactionManager.createTestTransactionManager();
                        AccessControlManager accessControlManagerNoPatterns = this.newAccessControlManager(transactionManager, "catalog.json");
                        accessControlManagerNoPatterns.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void testCatalogOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(admin, allCatalogs), allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(alice, allCatalogs), (Set)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(bob, allCatalogs), (Set)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(nonAsciiUser, allCatalogs), (Set)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testSchemaOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, alice, "alice-catalog", (Set)aliceSchemas), (Set)aliceSchemas);
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, bob, "alice-catalog", (Set)aliceSchemas), (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateSchema(transactionId, alice, aliceSchema);
            accessControlManager.checkCanDropSchema(transactionId, alice, aliceSchema);
            accessControlManager.checkCanRenameSchema(transactionId, alice, aliceSchema, "new-schema");
            accessControlManager.checkCanShowSchemas(transactionId, alice, "alice-catalog");
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(transactionId, bob, aliceSchema)));
    }

    @Test
    public void testTableOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, alice, "alice-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, bob, "alice-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateTable(transactionId, alice, aliceTable);
            accessControlManager.checkCanDropTable(transactionId, alice, aliceTable);
            accessControlManager.checkCanSelectFromColumns(transactionId, alice, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(transactionId, alice, aliceTable);
            accessControlManager.checkCanDeleteFromTable(transactionId, alice, aliceTable);
            accessControlManager.checkCanAddColumns(transactionId, alice, aliceTable);
            accessControlManager.checkCanRenameColumn(transactionId, alice, aliceTable);
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(transactionId, bob, aliceTable)));
    }

    @Test
    public void testViewOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateView(transactionId, alice, aliceView);
            accessControlManager.checkCanDropView(transactionId, alice, aliceView);
            accessControlManager.checkCanSelectFromColumns(transactionId, alice, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, alice, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, alice, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(transactionId, alice, "alice-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(transactionId, alice, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(transactionId, alice, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true);
        });
        Assert.assertThrows(AccessDeniedException.class, () -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, bob, aliceView)));
    }

    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(SystemAccessControl.class, FileBasedSystemAccessControl.class);
    }

    @Test
    public void testRefreshing() throws Exception {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        File configFile = Files.newTemporaryFile();
        configFile.deleteOnExit();
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("catalog.json")), (File)configFile);
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)configFile.getAbsolutePath(), (Object)"security.refresh-period", (Object)"1ms"));
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateView(transactionId, alice, aliceView);
            accessControlManager.checkCanCreateView(transactionId, alice, aliceView);
            accessControlManager.checkCanCreateView(transactionId, alice, aliceView);
        });
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("security-config-file-with-unknown-rules.json")), (File)configFile);
        Thread.sleep(2L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, aliceView))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, aliceView))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("catalog.json")), (File)configFile);
        Thread.sleep(2L);
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(transactionId, alice, aliceView));
    }

    private AccessControlManager newAccessControlManager(TransactionManager transactionManager, String resourceName) {
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)this.getResourcePath(resourceName)));
        return accessControlManager;
    }

    private String getResourcePath(String resourceName) {
        return this.getClass().getClassLoader().getResource(resourceName).getPath();
    }

    @Test
    public void parseUnknownRules() {
        Assertions.assertThatThrownBy(() -> this.parse("src/test/resources/security-config-file-with-unknown-rules.json")).hasMessageContaining("Invalid JSON");
    }

    private SystemAccessControl parse(String path) {
        return new FileBasedSystemAccessControl.Factory().create((Map)ImmutableMap.of((Object)"security.config-file", (Object)path));
    }
}

